/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.channel.http;

import com.clarifai.channel.ClarifaiException;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public interface ClarifaiHttpClient {
    public String executeRequest(String var1, String var2, String var3, JsonObject var4);

    public static class Default
    implements ClarifaiHttpClient {
        public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf8");
        private final String baseUrl;
        private OkHttpClient okHttpClient;

        public Default() {
            this("https://api.clarifai.com");
        }

        public Default(@NotNull String baseUrl) {
            this(baseUrl, new OkHttpClient());
        }

        public Default(@NotNull String baseUrl, @NotNull OkHttpClient okHttpClient) {
            this.baseUrl = baseUrl;
            this.okHttpClient = okHttpClient;
        }

        @Override
        @NotNull
        public String executeRequest(String apiKey, String subUrl, String method, JsonObject requestObject) {
            String responseString;
            HttpUrl.Builder url = HttpUrl.parse((String)(this.baseUrl + subUrl)).newBuilder();
            RequestBody body = null;
            if (method.toUpperCase().equals("GET")) {
                for (Map.Entry<String, String> entry : this.encodeGetParameters(requestObject).entrySet()) {
                    url.addQueryParameter(entry.getKey(), entry.getValue());
                }
            } else {
                body = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)new Gson().toJson((JsonElement)requestObject));
            }
            Request request = new Request.Builder().url(url.build()).addHeader("Authorization", "Key " + apiKey).method(method, body).build();
            try {
                Response response = this.okHttpClient.newCall(request).execute();
                responseString = response.body().string();
            }
            catch (IOException e) {
                throw new ClarifaiException(e);
            }
            return responseString;
        }

        private Map<String, String> encodeGetParameters(JsonObject requestObject) {
            HashMap<String, String> encodedParameters = new HashMap<String, String>();
            for (Map.Entry entry : requestObject.entrySet()) {
                String k = (String)entry.getKey();
                JsonElement v = (JsonElement)entry.getValue();
                if (v.isJsonPrimitive()) {
                    JsonPrimitive vPrimitive = v.getAsJsonPrimitive();
                    if (vPrimitive.isString()) {
                        encodedParameters.put(k, v.getAsString());
                        continue;
                    }
                    if (vPrimitive.isBoolean()) {
                        encodedParameters.put(k, String.valueOf(v.getAsBoolean()));
                        continue;
                    }
                    if (!vPrimitive.isNumber()) continue;
                    encodedParameters.put(k, v.getAsNumber().toString());
                    continue;
                }
                if (v.isJsonObject()) {
                    for (Map.Entry<String, String> subEntry : this.encodeGetParameters(v.getAsJsonObject()).entrySet()) {
                        String subK = subEntry.getKey();
                        String subV = subEntry.getValue();
                        encodedParameters.put(k + "." + subK, subV);
                    }
                    continue;
                }
                throw new ClarifaiException(String.format("Cannot convert type for get params: %s", v.getClass()));
            }
            return encodedParameters;
        }
    }
}

