/*
 * Decompiled with CFR 0.152.
 */
package com.clearlydecoded.commander;

import com.clearlydecoded.commander.Command;
import com.clearlydecoded.commander.CommandHandler;
import com.clearlydecoded.commander.CommandHandlerRegistry;
import com.clearlydecoded.commander.CommandResponse;
import com.clearlydecoded.commander.discovery.CommandHandlerVerifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultCommandHandlerRegistry
implements CommandHandlerRegistry {
    private static final Logger log = Logger.getLogger(DefaultCommandHandlerRegistry.class.getName());
    private Map<String, CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse>> handlerMap = new HashMap<String, CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse>>();

    @Override
    public void addHandler(CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse> commandHandler) {
        CommandHandlerVerifier.verifyCommandHandlerCompatibility(commandHandler);
        String handlerCommandStringType = commandHandler.getCompatibleCommandType();
        this.handlerMap.put(handlerCommandStringType, commandHandler);
        Class<? extends Command<? extends CommandResponse>> handledCommand = commandHandler.getCompatibleCommandClassType();
        String messageTemplate = "Registered [{0}] to handle commands of type [{1}] identified by [{2}]";
        if (log.isLoggable(Level.INFO)) {
            String infoMessage = MessageFormat.format(messageTemplate, commandHandler.getClass().getSimpleName(), handledCommand.getSimpleName(), handlerCommandStringType);
            log.info(infoMessage);
        } else if (log.isLoggable(Level.FINE)) {
            String debugMessage = MessageFormat.format(messageTemplate, commandHandler.getClass().getName(), handledCommand.getName(), handlerCommandStringType);
            log.info(debugMessage);
        }
    }

    @Override
    public void addHandlers(List<? extends CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse>> commandHandlers) {
        if (commandHandlers == null) {
            log.warning("No CommandHandlers provided. No CommandHandlers will be registered or available.");
            return;
        }
        commandHandlers.forEach(this::addHandler);
    }

    @Override
    public CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse> getHandlerFor(String commandType) {
        log.fine("Retrieving handler for Command identifier type [" + commandType + "].");
        return this.handlerMap.get(commandType);
    }

    @Override
    public void removeHandler(String commandType) {
        log.fine("Removing handler for Command identifier type [" + commandType + "].");
        this.handlerMap.remove(commandType);
    }

    @Override
    public List<CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse>> getHandlers() {
        return new ArrayList<CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse>>(this.handlerMap.values());
    }
}

