/*
 * Decompiled with CFR 0.152.
 */
package com.clearlydecoded.commander.discovery;

import com.clearlydecoded.commander.Command;
import com.clearlydecoded.commander.CommandHandler;
import com.clearlydecoded.commander.CommandResponse;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class CommandHandlerVerifier {
    private static final Logger log = Logger.getLogger(CommandHandlerVerifier.class.getName());

    public static void verifyCommandHandlerCompatibility(CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse> commandHandler) throws IllegalStateException {
        Class<? extends Command<? extends CommandResponse>> handlerCommandClassType = commandHandler.getCompatibleCommandClassType();
        String handlerCommandStringType = commandHandler.getCompatibleCommandType();
        try {
            Command<? extends CommandResponse> command = handlerCommandClassType.newInstance();
            if (handlerCommandStringType == null || !handlerCommandStringType.equals(command.getType())) {
                String messageTemplate = "Command commandHandler of type [{0}] is NOT valid! It declares to handle commands of type [{1}]. Handler''s getCompatibleCommandType() returns [{2}], but command''s getType() returns [{3}]. These must return identical string-based identifiers.";
                String message = MessageFormat.format(messageTemplate, commandHandler.getClass(), handlerCommandClassType, handlerCommandStringType, command.getType());
                log.severe(message);
                throw new IllegalStateException(message);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            String messageTemplate = "Error trying to verify command commandHandler [{0}]. Did not find public no-argument constructor on the command class of type [{1}]. Command implementations must have public no-argument constructor.";
            String message = MessageFormat.format(messageTemplate, commandHandler.getClass(), handlerCommandClassType);
            log.severe(message);
            throw new IllegalStateException(message, e);
        }
        Class<? extends CommandResponse> commandResponseClass = commandHandler.getCompatibleCommandResponseClassType();
        try {
            CommandResponse messageTemplate = commandResponseClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            String messageTemplate = "Error trying to verify command commandHandler [{0}]. Did not find public no-argument constructor on the command response class of type [{1}]. Command response implementations must have public no-argument constructor.";
            String message = MessageFormat.format(messageTemplate, commandHandler.getClass(), commandResponseClass);
            log.severe(message);
            throw new IllegalStateException(message, e);
        }
    }
}

