/*
 * Decompiled with CFR 0.152.
 */
package com.clearlydecoded.commander.discovery;

import com.clearlydecoded.commander.Command;
import com.clearlydecoded.commander.CommandHandler;
import com.clearlydecoded.commander.CommandResponse;
import com.clearlydecoded.commander.discovery.CommandHandlerDiscoverer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;

public class SpringCommandHandlerDiscoverer
implements CommandHandlerDiscoverer {
    private static final Logger log = Logger.getLogger(SpringCommandHandlerDiscoverer.class.getName());
    private ApplicationContext springContext;

    public SpringCommandHandlerDiscoverer(ApplicationContext springContext) {
        this.springContext = springContext;
    }

    @Override
    public List<? extends CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse>> discoverHandlers() {
        Map beanMap = this.springContext.getBeansOfType(CommandHandler.class);
        Set beanNames = beanMap.keySet();
        ArrayList<CommandHandler> commandHandlers = new ArrayList<CommandHandler>();
        for (String beanName : beanNames) {
            CommandHandler commandHandler = (CommandHandler)beanMap.get(beanName);
            commandHandlers.add(commandHandler);
        }
        if (commandHandlers.size() == 0) {
            String message = "No command handlers were discovered in Spring Context.";
            message = message + " If you think you have CommandHandler classes implemented, check that your";
            message = message + " command handler classes are injected into Spring Context either by manually";
            message = message + " injecting them (in an @Configuration class) or by having the command handler";
            message = message + " classes annotated with either @Service, @Component, etc.";
            log.warning(message);
        }
        return commandHandlers;
    }
}

