/*
 * Decompiled with CFR 0.152.
 */
package com.clearlydecoded.commander.documentation;

import com.clearlydecoded.commander.Command;
import com.clearlydecoded.commander.CommandHandler;
import com.clearlydecoded.commander.CommandResponse;
import com.clearlydecoded.commander.documentation.RestCommandHandlerDocumentation;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.types.AnySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RestCommandHandlerDocumentationGenerator {
    private static ObjectMapper mapper = new ObjectMapper();
    private static JsonSchemaGenerator schemaGenerator = new JsonSchemaGenerator(mapper);
    private static String spacePadding = "  ";

    public static RestCommandHandlerDocumentation generateDocumentation(CommandHandler commandHandler) throws Exception {
        RestCommandHandlerDocumentation documentation = new RestCommandHandlerDocumentation();
        Class commandClass = commandHandler.getCompatibleCommandClassType();
        Class commandResponseClass = commandHandler.getCompatibleCommandResponseClassType();
        String commandDocs = RestCommandHandlerDocumentationGenerator.generateCommandDocumentation(commandClass);
        String commandResponseDocs = RestCommandHandlerDocumentationGenerator.generateCommandResponseDocumentation(commandResponseClass);
        documentation.setCommandModel(commandDocs);
        documentation.setCommandShortClassName(commandClass.getSimpleName());
        documentation.setCommandResponseModel(commandResponseDocs);
        documentation.setCommandResponseShortClassName(commandResponseClass.getSimpleName());
        return documentation;
    }

    private static String generateCommandDocumentation(Class<? extends Command> commandClass) throws Exception {
        StringBuilder model = new StringBuilder();
        model.append("{\n").append(spacePadding);
        model.append(RestCommandHandlerDocumentationGenerator.getCommandType(commandClass));
        ObjectSchema commandSchema = schemaGenerator.generateSchema(commandClass).asObjectSchema();
        Map propertiesMap = commandSchema.getProperties();
        Set propNames = propertiesMap.keySet();
        propNames.remove("type");
        List<String> jsonEntries = propNames.stream().map(propName -> {
            JsonSchema propSchema = (JsonSchema)propertiesMap.get(propName);
            return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, propSchema, spacePadding);
        }).collect(Collectors.toList());
        jsonEntries.forEach(model::append);
        model.append("\n}");
        return model.toString();
    }

    private static String generateCommandResponseDocumentation(Class<? extends CommandResponse> commandResponseClass) throws Exception {
        StringBuilder model = new StringBuilder();
        model.append("{");
        JsonSchema schema = schemaGenerator.generateSchema(commandResponseClass);
        if (!(schema instanceof AnySchema)) {
            ObjectSchema commandSchema = schemaGenerator.generateSchema(commandResponseClass).asObjectSchema();
            Map propertiesMap = commandSchema.getProperties();
            Set propNames = propertiesMap.keySet();
            List<String> jsonEntries = propNames.stream().map(propName -> {
                JsonSchema propSchema = (JsonSchema)propertiesMap.get(propName);
                return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, propSchema, spacePadding);
            }).collect(Collectors.toList());
            jsonEntries.forEach(model::append);
        }
        model.append("\n}");
        return model.toString();
    }

    private static String getCommandType(Class<? extends Command> commandClass) throws Exception {
        Command command = commandClass.newInstance();
        String type = command.getType();
        return "\"type\": \"" + type + "\"";
    }

    private static String getJsonEntry(String propName, JsonSchema jsonSchema, String currentPadding) {
        if (jsonSchema instanceof ReferenceSchema) {
            ReferenceSchema refSchema = (ReferenceSchema)jsonSchema;
            String refObject = refSchema.get$ref();
            int lastColonIndex = refObject.lastIndexOf(":");
            String objectReference = refObject.substring(lastColonIndex + 1);
            if (propName == null) {
                return "\n" + currentPadding + objectReference + " self reference";
            }
            return "\n" + currentPadding + "\"" + propName + "\": " + objectReference + " self reference";
        }
        JsonFormatTypes schemaType = jsonSchema.getType();
        switch (schemaType) {
            case ARRAY: {
                return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, jsonSchema.asArraySchema(), currentPadding);
            }
            case OBJECT: {
                return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, jsonSchema.asObjectSchema(), currentPadding);
            }
            case BOOLEAN: {
                return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, jsonSchema.asBooleanSchema(), currentPadding);
            }
            case INTEGER: {
                return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, jsonSchema.asIntegerSchema(), currentPadding);
            }
            case NUMBER: {
                return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, jsonSchema.asNumberSchema(), currentPadding);
            }
            case STRING: {
                return RestCommandHandlerDocumentationGenerator.getJsonEntry(propName, jsonSchema.asStringSchema(), currentPadding);
            }
            case ANY: {
                return null;
            }
        }
        return "could not parse: unsupported schema";
    }

    private static String getJsonEntry(String propName, ArraySchema arraySchema, String currentPadding) {
        String output = propName == null ? "\n" + currentPadding + "[" : "\n" + currentPadding + "\"" + propName + "\": [";
        String newSpacePadding = currentPadding + spacePadding;
        JsonSchema arrayItemsSchema = arraySchema.getItems().asSingleItems().getSchema();
        output = output + RestCommandHandlerDocumentationGenerator.getJsonEntry(null, arrayItemsSchema, newSpacePadding);
        output = output + "\n" + currentPadding + "]";
        return output;
    }

    private static String getJsonEntry(String propName, ObjectSchema objectSchema, String currentPadding) {
        String output = propName == null ? "\n" + currentPadding + "{" : "\n" + currentPadding + "\"" + propName + "\": {";
        String newSpacePadding = currentPadding + spacePadding;
        Map propertiesMap = objectSchema.getProperties();
        StringBuilder outputBuilder = new StringBuilder();
        for (String objectPropName : propertiesMap.keySet()) {
            outputBuilder.append(RestCommandHandlerDocumentationGenerator.getJsonEntry(objectPropName, (JsonSchema)propertiesMap.get(objectPropName), newSpacePadding));
        }
        output = output + outputBuilder.toString();
        output = output + "\n" + currentPadding + "}";
        return output;
    }

    private static String getJsonEntry(String propName, BooleanSchema booleanSchema, String currentPadding) {
        if (propName == null) {
            return "\n" + currentPadding + "boolean";
        }
        return "\n" + currentPadding + "\"" + propName + "\": boolean";
    }

    private static String getJsonEntry(String propName, IntegerSchema integerSchema, String currentPadding) {
        if (propName == null) {
            return "\n" + currentPadding + "number";
        }
        return "\n" + currentPadding + "\"" + propName + "\": number";
    }

    private static String getJsonEntry(String propName, NumberSchema numberSchema, String currentPadding) {
        if (propName == null) {
            return "\n" + currentPadding + "number";
        }
        return "\n" + currentPadding + "\"" + propName + "\": number";
    }

    private static String getJsonEntry(String propName, StringSchema stringSchema, String currentPadding) {
        if (propName == null) {
            return "\n" + currentPadding + "\"string\"";
        }
        return "\n" + currentPadding + "\"" + propName + "\": \"string\"";
    }
}

