/*
 * Decompiled with CFR 0.152.
 */
package com.clearlydecoded.commander.rest;

import com.clearlydecoded.commander.Command;
import com.clearlydecoded.commander.CommandHandler;
import com.clearlydecoded.commander.CommandHandlerRegistry;
import com.clearlydecoded.commander.CommandResponse;
import com.clearlydecoded.commander.discovery.SpringCommandHandlerRegistryFactory;
import com.clearlydecoded.commander.documentation.RestCommandHandlerDocumentation;
import com.clearlydecoded.commander.documentation.RestCommandHandlerDocumentationGenerator;
import com.clearlydecoded.commander.rest.CommandWithJustType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class SpringRestCommander {
    private static final Logger log = Logger.getLogger(SpringRestCommander.class.getName());
    @Value(value="${com.clearlydecoded.commander.endpoint.uri:execute}")
    private String endpointUri;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private CommandHandlerRegistry commandHandlerRegistry;
    private List<RestCommandHandlerDocumentation> handlerDocs;

    public SpringRestCommander(ApplicationContext springContext) {
        this(SpringCommandHandlerRegistryFactory.discoverCommandHandlersAndCreateRegistry(springContext));
    }

    public SpringRestCommander(CommandHandlerRegistry commandHandlerRegistry) {
        this.commandHandlerRegistry = commandHandlerRegistry;
        this.handlerDocs = new ArrayList<RestCommandHandlerDocumentation>();
        try {
            for (CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse> commandHandler : commandHandlerRegistry.getHandlers()) {
                RestCommandHandlerDocumentation documentation = RestCommandHandlerDocumentationGenerator.generateDocumentation(commandHandler);
                this.handlerDocs.add(documentation);
            }
        }
        catch (Exception e) {
            String message = "Generating command handler documentation failed. However, this will NOTaffect the functionality of the rest of the application. While it is most probably a bug, it can be safely ignored because it only affects the documentation of the REST API.";
            log.severe(message);
        }
    }

    @PostConstruct
    private void createRequestMapping() throws Exception {
        String message = "REST-COMMANDER endpoint configured for URI: /" + this.endpointUri;
        message = message + ". To configure custom URI, supply 'com.clearlydecoded.commander.endpoint.uri'";
        message = message + " property.";
        log.info(message);
        RequestMappingInfo commandExecutionRequestMappingInfo = RequestMappingInfo.paths((String[])new String[]{this.endpointUri}).methods(new RequestMethod[]{RequestMethod.POST}).consumes(new String[]{"application/json"}).produces(new String[]{"application/json"}).build();
        this.requestMappingHandlerMapping.registerMapping((Object)commandExecutionRequestMappingInfo, (Object)this, SpringRestCommander.class.getDeclaredMethod("execute", String.class));
    }

    @ResponseBody
    private <CommandT extends Command<CommandResponseT>, CommandResponseT extends CommandResponse> String execute(@RequestBody String command) {
        String response;
        Command javaTypedCommand;
        CommandWithJustType typedCommand;
        log.fine("Full command string received: " + command);
        ObjectMapper mapper = new ObjectMapper();
        try {
            typedCommand = (CommandWithJustType)mapper.readValue(command, CommandWithJustType.class);
        }
        catch (IOException e) {
            String message = "Error deserializing command type identifier from JSON: " + command;
            log.severe(message);
            throw new IllegalArgumentException(message, e);
        }
        String commandType = typedCommand.getType();
        log.fine("Identified command with type identifier: [" + commandType + "].");
        CommandHandler<? extends Command<? extends CommandResponse>, ? extends CommandResponse> commandHandler = this.commandHandlerRegistry.getHandlerFor(commandType);
        if (commandHandler == null) {
            String message = "No registered command handler found for command type [" + commandType + "]";
            message = message + ". If you think you have a CommandHandler class implemented for this command type";
            message = message + ", check that your command handler class is injected into Spring Context either";
            message = message + " by manually injecting it (in an @Configuration class) or by having the command";
            message = message + " handler class annotated with either @Service, @Component, etc.";
            log.severe(message);
            throw new IllegalArgumentException("Command with type [" + commandType + "] is not supported.");
        }
        Class<? extends Command<? extends CommandResponse>> handlersCommandClassType = commandHandler.getCompatibleCommandClassType();
        try {
            javaTypedCommand = (Command)mapper.readValue(command, handlersCommandClassType);
        }
        catch (IOException e) {
            String message = "Error deserializing " + command + " to " + handlersCommandClassType;
            log.severe(message);
            throw new IllegalArgumentException(message, e);
        }
        log.fine("Command about to be executed: " + javaTypedCommand);
        CommandResponse commandResponse = commandHandler.execute(javaTypedCommand);
        try {
            response = mapper.writeValueAsString((Object)commandResponse);
        }
        catch (JsonProcessingException e) {
            String message = "Error serializing " + commandResponse + " to JSON";
            log.severe(message);
            throw new IllegalArgumentException(message, e);
        }
        log.fine("Full command response string to be sent: " + response);
        return response;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public void setRequestMappingHandlerMapping(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }
}

