/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.models.components.DeletedObject;
import com.clerk.backend_api.models.components.OrganizationDomain;
import com.clerk.backend_api.models.errors.ClerkErrors;
import com.clerk.backend_api.models.errors.SDKError;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequestBody;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequestBuilder;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainResponse;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainResponse;
import com.clerk.backend_api.models.operations.ListOrganizationDomainsRequest;
import com.clerk.backend_api.models.operations.ListOrganizationDomainsRequestBuilder;
import com.clerk.backend_api.models.operations.ListOrganizationDomainsResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainResponse;
import com.clerk.backend_api.utils.BackoffStrategy;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.HTTPRequest;
import com.clerk.backend_api.utils.Hook;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.Retries;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.SerializedBody;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class OrganizationDomains
implements SDKMethodInterfaces.MethodCallCreateOrganizationDomain,
SDKMethodInterfaces.MethodCallListOrganizationDomains,
SDKMethodInterfaces.MethodCallUpdateOrganizationDomain,
SDKMethodInterfaces.MethodCallDeleteOrganizationDomain {
    private final SDKConfiguration sdkConfiguration;

    OrganizationDomains(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateOrganizationDomainRequestBuilder create() {
        return new CreateOrganizationDomainRequestBuilder(this);
    }

    public CreateOrganizationDomainResponse create(String organizationId, CreateOrganizationDomainRequestBody requestBody) throws Exception {
        return this.create(organizationId, requestBody, Optional.empty());
    }

    @Override
    public CreateOrganizationDomainResponse create(String organizationId, CreateOrganizationDomainRequestBody requestBody, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        CreateOrganizationDomainRequest request = CreateOrganizationDomainRequest.builder().organizationId(organizationId).requestBody(requestBody).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CreateOrganizationDomainRequest.class, _baseUrl, "/organizations/{organization_id}/domains", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "requestBody", "json", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "CreateOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "CreateOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "CreateOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateOrganizationDomainResponse.Builder _resBuilder = CreateOrganizationDomainResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CreateOrganizationDomainResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                OrganizationDomain _out = (OrganizationDomain)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<OrganizationDomain>(){});
                _res.withOrganizationDomain(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "404", "422")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public ListOrganizationDomainsRequestBuilder list() {
        return new ListOrganizationDomainsRequestBuilder(this);
    }

    public ListOrganizationDomainsResponse list(ListOrganizationDomainsRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    @Override
    public ListOrganizationDomainsResponse list(ListOrganizationDomainsRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(ListOrganizationDomainsRequest.class, _baseUrl, "/organizations/{organization_id}/domains", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(ListOrganizationDomainsRequest.class, request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "ListOrganizationDomains", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "ListOrganizationDomains", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "ListOrganizationDomains", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        ListOrganizationDomainsResponse.Builder _resBuilder = ListOrganizationDomainsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        ListOrganizationDomainsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                com.clerk.backend_api.models.components.OrganizationDomains _out = (com.clerk.backend_api.models.components.OrganizationDomains)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<com.clerk.backend_api.models.components.OrganizationDomains>(){});
                _res.withOrganizationDomains(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "401", "422")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public UpdateOrganizationDomainRequestBuilder update() {
        return new UpdateOrganizationDomainRequestBuilder(this);
    }

    public UpdateOrganizationDomainResponse update(String organizationId, String domainId, UpdateOrganizationDomainRequestBody requestBody) throws Exception {
        return this.update(organizationId, domainId, requestBody, Optional.empty());
    }

    @Override
    public UpdateOrganizationDomainResponse update(String organizationId, String domainId, UpdateOrganizationDomainRequestBody requestBody, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        UpdateOrganizationDomainRequest request = UpdateOrganizationDomainRequest.builder().organizationId(organizationId).domainId(domainId).requestBody(requestBody).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(UpdateOrganizationDomainRequest.class, _baseUrl, "/organizations/{organization_id}/domains/{domain_id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "PATCH");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "requestBody", "json", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "UpdateOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "UpdateOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "UpdateOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        UpdateOrganizationDomainResponse.Builder _resBuilder = UpdateOrganizationDomainResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        UpdateOrganizationDomainResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                OrganizationDomain _out = (OrganizationDomain)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<OrganizationDomain>(){});
                _res.withOrganizationDomain(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "404", "422")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public DeleteOrganizationDomainRequestBuilder delete() {
        return new DeleteOrganizationDomainRequestBuilder(this);
    }

    public DeleteOrganizationDomainResponse delete(String organizationId, String domainId) throws Exception {
        return this.delete(organizationId, domainId, Optional.empty());
    }

    @Override
    public DeleteOrganizationDomainResponse delete(String organizationId, String domainId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        DeleteOrganizationDomainRequest request = DeleteOrganizationDomainRequest.builder().organizationId(organizationId).domainId(domainId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(DeleteOrganizationDomainRequest.class, _baseUrl, "/organizations/{organization_id}/domains/{domain_id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "DELETE");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "DeleteOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "DeleteOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "DeleteOrganizationDomain", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        DeleteOrganizationDomainResponse.Builder _resBuilder = DeleteOrganizationDomainResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        DeleteOrganizationDomainResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                DeletedObject _out = (DeletedObject)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<DeletedObject>(){});
                _res.withDeletedObject(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

