/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.hooks.SDKHooks;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.Hook;
import com.clerk.backend_api.utils.Hooks;
import com.clerk.backend_api.utils.RetryConfig;
import java.util.Optional;

class SDKConfiguration {
    public SecuritySource securitySource;
    public HTTPClient defaultClient;
    public String serverUrl;
    public int serverIdx = 0;
    private static final String LANGUAGE = "java";
    public static final String OPENAPI_DOC_VERSION = "2024-10-01";
    public static final String SDK_VERSION = "2.3.1";
    public static final String GEN_VERSION = "2.563.1";
    private static final String BASE_PACKAGE = "com.clerk.backend_api";
    public static final String USER_AGENT = String.format("speakeasy-sdk/%s %s %s %s %s", "java", "2.3.1", "2.563.1", "2024-10-01", "com.clerk.backend_api");
    private Hooks _hooks = SDKConfiguration.createHooks();
    public Optional<RetryConfig> retryConfig = Optional.empty();

    SDKConfiguration() {
    }

    public Optional<SecuritySource> securitySource() {
        return Optional.ofNullable(this.securitySource);
    }

    public String resolvedServerUrl() {
        return this.serverUrl;
    }

    private static Hooks createHooks() {
        Hooks hooks = new Hooks();
        return hooks;
    }

    public Hooks hooks() {
        return this._hooks;
    }

    public void setHooks(Hooks hooks) {
        this._hooks = hooks;
    }

    public void initialize() {
        SDKHooks.initialize(this._hooks);
        Hook.SdkInitData data = this._hooks.sdkInit(new Hook.SdkInitData(this.resolvedServerUrl(), this.defaultClient));
        this.serverUrl = data.baseUrl();
        this.defaultClient = data.client();
    }
}

