/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.models.components.Session;
import com.clerk.backend_api.models.components.SessionRefresh;
import com.clerk.backend_api.models.errors.ClerkErrors;
import com.clerk.backend_api.models.errors.SDKError;
import com.clerk.backend_api.models.operations.CreateSessionRequestBody;
import com.clerk.backend_api.models.operations.CreateSessionRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSessionResponse;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateRequest;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateRequestBody;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateResponse;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateResponseBody;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequest;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequestBody;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSessionTokenResponse;
import com.clerk.backend_api.models.operations.CreateSessionTokenResponseBody;
import com.clerk.backend_api.models.operations.GetSessionListRequest;
import com.clerk.backend_api.models.operations.GetSessionListRequestBuilder;
import com.clerk.backend_api.models.operations.GetSessionListResponse;
import com.clerk.backend_api.models.operations.GetSessionRequest;
import com.clerk.backend_api.models.operations.GetSessionRequestBuilder;
import com.clerk.backend_api.models.operations.GetSessionResponse;
import com.clerk.backend_api.models.operations.RefreshSessionRequest;
import com.clerk.backend_api.models.operations.RefreshSessionRequestBody;
import com.clerk.backend_api.models.operations.RefreshSessionRequestBuilder;
import com.clerk.backend_api.models.operations.RefreshSessionResponse;
import com.clerk.backend_api.models.operations.RevokeSessionRequest;
import com.clerk.backend_api.models.operations.RevokeSessionRequestBuilder;
import com.clerk.backend_api.models.operations.RevokeSessionResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.models.operations.VerifySessionRequest;
import com.clerk.backend_api.models.operations.VerifySessionRequestBody;
import com.clerk.backend_api.models.operations.VerifySessionRequestBuilder;
import com.clerk.backend_api.models.operations.VerifySessionResponse;
import com.clerk.backend_api.utils.BackoffStrategy;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.HTTPRequest;
import com.clerk.backend_api.utils.Hook;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.Retries;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.SerializedBody;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Sessions
implements SDKMethodInterfaces.MethodCallGetSessionList,
SDKMethodInterfaces.MethodCallCreateSession,
SDKMethodInterfaces.MethodCallGetSession,
SDKMethodInterfaces.MethodCallRefreshSession,
SDKMethodInterfaces.MethodCallRevokeSession,
SDKMethodInterfaces.MethodCallVerifySession,
SDKMethodInterfaces.MethodCallCreateSessionToken,
SDKMethodInterfaces.MethodCallCreateSessionTokenFromTemplate {
    private final SDKConfiguration sdkConfiguration;

    Sessions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetSessionListRequestBuilder list() {
        return new GetSessionListRequestBuilder(this);
    }

    public GetSessionListResponse list(GetSessionListRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    @Override
    public GetSessionListResponse list(GetSessionListRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/sessions");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(GetSessionListRequest.class, request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "GetSessionList", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "GetSessionList", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "GetSessionList", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetSessionListResponse.Builder _resBuilder = GetSessionListResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetSessionListResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List _out = (List)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<List<Session>>(){});
                _res.withSessionList(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "422")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CreateSessionRequestBuilder create() {
        return new CreateSessionRequestBuilder(this);
    }

    public CreateSessionResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    @Override
    public CreateSessionResponse create(Optional<? extends CreateSessionRequestBody> request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/sessions");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Optional<? extends CreateSessionRequestBody>>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "request", "json", false);
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "createSession", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "createSession", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "createSession", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateSessionResponse.Builder _resBuilder = CreateSessionResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CreateSessionResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Session _out = (Session)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Session>(){});
                _res.withSession(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "404", "422")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GetSessionRequestBuilder get() {
        return new GetSessionRequestBuilder(this);
    }

    public GetSessionResponse get(String sessionId) throws Exception {
        return this.get(sessionId, Optional.empty());
    }

    @Override
    public GetSessionResponse get(String sessionId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        GetSessionRequest request = GetSessionRequest.builder().sessionId(sessionId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(GetSessionRequest.class, _baseUrl, "/sessions/{session_id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "GetSession", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "GetSession", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "GetSession", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetSessionResponse.Builder _resBuilder = GetSessionResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetSessionResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Session _out = (Session)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Session>(){});
                _res.withSession(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public RefreshSessionRequestBuilder refresh() {
        return new RefreshSessionRequestBuilder(this);
    }

    public RefreshSessionResponse refresh(String sessionId) throws Exception {
        return this.refresh(sessionId, Optional.empty(), Optional.empty());
    }

    @Override
    public RefreshSessionResponse refresh(String sessionId, Optional<? extends RefreshSessionRequestBody> requestBody, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        RefreshSessionRequest request = RefreshSessionRequest.builder().sessionId(sessionId).requestBody(requestBody).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(RefreshSessionRequest.class, _baseUrl, "/sessions/{session_id}/refresh", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "requestBody", "json", false);
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "RefreshSession", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "RefreshSession", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "RefreshSession", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        RefreshSessionResponse.Builder _resBuilder = RefreshSessionResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        RefreshSessionResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                SessionRefresh _out = (SessionRefresh)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<SessionRefresh>(){});
                _res.withSessionRefresh(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public RevokeSessionRequestBuilder revoke() {
        return new RevokeSessionRequestBuilder(this);
    }

    public RevokeSessionResponse revoke(String sessionId) throws Exception {
        return this.revoke(sessionId, Optional.empty());
    }

    @Override
    public RevokeSessionResponse revoke(String sessionId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        RevokeSessionRequest request = RevokeSessionRequest.builder().sessionId(sessionId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(RevokeSessionRequest.class, _baseUrl, "/sessions/{session_id}/revoke", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "RevokeSession", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "RevokeSession", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "RevokeSession", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        RevokeSessionResponse.Builder _resBuilder = RevokeSessionResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        RevokeSessionResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Session _out = (Session)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Session>(){});
                _res.withSession(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    @Deprecated
    public VerifySessionRequestBuilder verify() {
        return new VerifySessionRequestBuilder(this);
    }

    @Deprecated
    public VerifySessionResponse verify(String sessionId) throws Exception {
        return this.verify(sessionId, Optional.empty(), Optional.empty());
    }

    @Override
    @Deprecated
    public VerifySessionResponse verify(String sessionId, Optional<? extends VerifySessionRequestBody> requestBody, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        VerifySessionRequest request = VerifySessionRequest.builder().sessionId(sessionId).requestBody(requestBody).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(VerifySessionRequest.class, _baseUrl, "/sessions/{session_id}/verify", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "requestBody", "json", false);
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "VerifySession", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "VerifySession", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "VerifySession", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        VerifySessionResponse.Builder _resBuilder = VerifySessionResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        VerifySessionResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Session _out = (Session)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Session>(){});
                _res.withSession(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "404", "410")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CreateSessionTokenRequestBuilder createToken() {
        return new CreateSessionTokenRequestBuilder(this);
    }

    public CreateSessionTokenResponse createToken(String sessionId) throws Exception {
        return this.createToken(sessionId, Optional.empty(), Optional.empty());
    }

    @Override
    public CreateSessionTokenResponse createToken(String sessionId, Optional<? extends CreateSessionTokenRequestBody> requestBody, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        CreateSessionTokenRequest request = CreateSessionTokenRequest.builder().sessionId(sessionId).requestBody(requestBody).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CreateSessionTokenRequest.class, _baseUrl, "/sessions/{session_id}/tokens", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "requestBody", "json", false);
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "CreateSessionToken", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "CreateSessionToken", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "CreateSessionToken", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateSessionTokenResponse.Builder _resBuilder = CreateSessionTokenResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CreateSessionTokenResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                CreateSessionTokenResponseBody _out = (CreateSessionTokenResponseBody)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<CreateSessionTokenResponseBody>(){});
                _res.withObject(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "401", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CreateSessionTokenFromTemplateRequestBuilder createTokenFromTemplate() {
        return new CreateSessionTokenFromTemplateRequestBuilder(this);
    }

    public CreateSessionTokenFromTemplateResponse createTokenFromTemplate(String sessionId, String templateName) throws Exception {
        return this.createTokenFromTemplate(sessionId, templateName, Optional.empty(), Optional.empty());
    }

    @Override
    public CreateSessionTokenFromTemplateResponse createTokenFromTemplate(String sessionId, String templateName, Optional<? extends CreateSessionTokenFromTemplateRequestBody> requestBody, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        CreateSessionTokenFromTemplateRequest request = CreateSessionTokenFromTemplateRequest.builder().sessionId(sessionId).templateName(templateName).requestBody(requestBody).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CreateSessionTokenFromTemplateRequest.class, _baseUrl, "/sessions/{session_id}/tokens/{template_name}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "requestBody", "json", false);
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(_baseUrl, "CreateSessionTokenFromTemplate", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(_baseUrl, "CreateSessionTokenFromTemplate", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(_baseUrl, "CreateSessionTokenFromTemplate", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateSessionTokenFromTemplateResponse.Builder _resBuilder = CreateSessionTokenFromTemplateResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CreateSessionTokenFromTemplateResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                CreateSessionTokenFromTemplateResponseBody _out = (CreateSessionTokenFromTemplateResponseBody)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<CreateSessionTokenFromTemplateResponseBody>(){});
                _res.withObject(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "401", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

