/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.jwks;

import com.clerk.backend_api.helpers.jwks.AuthErrorReason;
import com.clerk.backend_api.helpers.jwks.AuthenticateRequestOptions;
import com.clerk.backend_api.helpers.jwks.RequestState;
import com.clerk.backend_api.helpers.jwks.TokenVerificationException;
import com.clerk.backend_api.helpers.jwks.VerifyToken;
import com.clerk.backend_api.helpers.jwks.VerifyTokenOptions;
import io.jsonwebtoken.Claims;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class AuthenticateRequest {
    private static final String SESSION_COOKIE_NAME = "__session";

    private AuthenticateRequest() {
    }

    public static final RequestState authenticateRequest(Map<String, List<String>> requestHeaders, AuthenticateRequestOptions options) {
        VerifyTokenOptions verifyTokenOptions;
        String sessionToken = AuthenticateRequest.getSessionToken(requestHeaders);
        if (sessionToken == null) {
            return RequestState.signedOut(AuthErrorReason.SESSION_TOKEN_MISSING);
        }
        if (options.jwtKey().isPresent()) {
            verifyTokenOptions = VerifyTokenOptions.jwtKey(options.jwtKey().get()).audience(options.audience()).authorizedParties(options.authorizedParties()).clockSkew(options.clockSkewInMs(), TimeUnit.MILLISECONDS).build();
        } else if (options.secretKey().isPresent()) {
            verifyTokenOptions = VerifyTokenOptions.secretKey(options.secretKey().get()).audience(options.audience()).authorizedParties(options.authorizedParties()).clockSkew(options.clockSkewInMs(), TimeUnit.MILLISECONDS).build();
        } else {
            return RequestState.signedOut(AuthErrorReason.SECRET_KEY_MISSING);
        }
        try {
            Claims claims = VerifyToken.verifyToken(sessionToken, verifyTokenOptions);
            return RequestState.signedIn(sessionToken, claims);
        }
        catch (TokenVerificationException e) {
            return RequestState.signedOut(e.reason());
        }
    }

    private static String getSessionToken(Map<String, List<String>> requestHeaders) {
        Map lowerCaseHeaders = requestHeaders.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(((String)e.getKey()).toLowerCase(), (List)e.getValue()), HashMap::putAll);
        List authHeaders = (List)lowerCaseHeaders.get("authorization");
        if (authHeaders != null && !authHeaders.isEmpty()) {
            String bearerToken = (String)authHeaders.get(0);
            return bearerToken.replace("Bearer ", "");
        }
        List cookieHeaders = (List)lowerCaseHeaders.get("cookie");
        if (cookieHeaders != null && !cookieHeaders.isEmpty()) {
            String cookieHeaderValue = (String)cookieHeaders.get(0);
            List<HttpCookie> cookies = HttpCookie.parse(cookieHeaderValue);
            for (HttpCookie cookie : cookies) {
                if (!cookie.getName().startsWith(SESSION_COOKIE_NAME)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

