/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.jwks;

import com.clerk.backend_api.helpers.jwks.AuthErrorReason;
import com.clerk.backend_api.helpers.jwks.AuthStatus;
import com.clerk.backend_api.helpers.jwks.ErrorReason;
import com.clerk.backend_api.helpers.jwks.TokenVerificationErrorReason;
import com.clerk.backend_api.utils.Utils;
import io.jsonwebtoken.Claims;
import java.util.Optional;

public final class RequestState {
    private final AuthStatus status;
    private final Optional<AuthErrorReason> authErrorReason;
    private final Optional<TokenVerificationErrorReason> tokenVerificationErrorReason;
    private final Optional<String> token;
    private final Optional<Claims> claims;

    public RequestState(AuthStatus status, Optional<AuthErrorReason> authErrorReason, Optional<TokenVerificationErrorReason> tokenVerificationErrorReason, Optional<String> token, Optional<Claims> claims) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(authErrorReason, "authErrorReason");
        Utils.checkNotNull(tokenVerificationErrorReason, "tokenVerificationErrorReason");
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(claims, "claims");
        if (authErrorReason.isPresent() && tokenVerificationErrorReason.isPresent()) {
            throw new IllegalArgumentException("Only one of authErrorReason or tokenVerificationErrorReason should be provided.");
        }
        this.status = status;
        this.authErrorReason = authErrorReason;
        this.tokenVerificationErrorReason = tokenVerificationErrorReason;
        this.token = token;
        this.claims = claims;
    }

    public static RequestState signedIn(String token, Claims claims) {
        return new RequestState(AuthStatus.SIGNED_IN, Optional.empty(), Optional.empty(), Optional.of(token), Optional.of(claims));
    }

    public static RequestState signedOut(AuthErrorReason reason) {
        return new RequestState(AuthStatus.SIGNED_OUT, Optional.of(reason), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static RequestState signedOut(TokenVerificationErrorReason reason) {
        return new RequestState(AuthStatus.SIGNED_OUT, Optional.empty(), Optional.of(reason), Optional.empty(), Optional.empty());
    }

    public AuthStatus status() {
        return this.status;
    }

    public boolean isSignedIn() {
        return this.status == AuthStatus.SIGNED_IN;
    }

    public boolean isSignedOut() {
        return this.status == AuthStatus.SIGNED_OUT;
    }

    public Optional<ErrorReason> reason() {
        if (this.authErrorReason.isPresent()) {
            return Optional.of((ErrorReason)this.authErrorReason.get());
        }
        if (this.tokenVerificationErrorReason.isPresent()) {
            return Optional.of((ErrorReason)this.tokenVerificationErrorReason.get());
        }
        return Optional.empty();
    }

    public Optional<String> token() {
        return this.token;
    }

    public Optional<Claims> claims() {
        return this.claims;
    }
}

