/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.jwks;

import com.clerk.backend_api.utils.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class VerifyTokenOptions {
    private static final long DEFAULT_CLOCK_SKEW_MS = 5000L;
    private static final String DEFAULT_API_URL = "https://api.clerk.com";
    private static final String DEFAULT_API_VERSION = "v1";
    private final Optional<String> secretKey;
    private final Optional<String> jwtKey;
    private final Optional<String> audience;
    private final Set<String> authorizedParties;
    private final long clockSkewInMs;
    private final String apiUrl;
    private final String apiVersion;

    public VerifyTokenOptions(Optional<String> secretKey, Optional<String> jwtKey, Optional<String> audience, Set<String> authorizedParties, Optional<Long> clockSkewInMs, Optional<String> apiUrl, Optional<String> apiVersion) {
        Utils.checkNotNull(audience, "audience");
        Utils.checkNotNull(authorizedParties, "authorizedParties");
        Utils.checkNotNull(clockSkewInMs, "clockSkewInMs");
        Utils.checkNotNull(jwtKey, "jwtKey");
        Utils.checkNotNull(secretKey, "secretKey");
        Utils.checkNotNull(apiUrl, "apiUrl");
        Utils.checkNotNull(apiVersion, "apiVersion");
        this.audience = audience;
        this.authorizedParties = authorizedParties;
        this.clockSkewInMs = clockSkewInMs.orElse(5000L);
        this.jwtKey = jwtKey;
        this.secretKey = secretKey;
        this.apiUrl = apiUrl.orElse(DEFAULT_API_URL);
        this.apiVersion = apiVersion.orElse(DEFAULT_API_VERSION);
    }

    public Optional<String> audience() {
        return this.audience;
    }

    public Set<String> authorizedParties() {
        return this.authorizedParties;
    }

    public long clockSkewInMs() {
        return this.clockSkewInMs;
    }

    public Optional<String> jwtKey() {
        return this.jwtKey;
    }

    public Optional<String> secretKey() {
        return this.secretKey;
    }

    public String apiUrl() {
        return this.apiUrl;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public static Builder secretKey(String secretKey) {
        return Builder.withSecretKey(secretKey);
    }

    public static Builder jwtKey(String jwtKey) {
        return Builder.withJwtKey(jwtKey);
    }

    public static final class Builder {
        private Optional<String> secretKey = Optional.empty();
        private Optional<String> jwtKey = Optional.empty();
        private Optional<String> audience = Optional.empty();
        private Set<String> authorizedParties = new HashSet<String>();
        private long clockSkewInMs = 5000L;
        private String apiUrl = "https://api.clerk.com";
        private String apiVersion = "v1";

        public static Builder withSecretKey(String secretKey) {
            Utils.checkNotNull(secretKey, "secretKey");
            Builder builder = new Builder();
            builder.secretKey = Optional.of(secretKey);
            return builder;
        }

        public static Builder withJwtKey(String jwtKey) {
            Utils.checkNotNull(jwtKey, "jwtKey");
            Builder builder = new Builder();
            builder.jwtKey = Optional.of(jwtKey);
            return builder;
        }

        public Builder audience(String audience) {
            Utils.checkNotNull(audience, "audience");
            return this.audience(Optional.of(audience));
        }

        public Builder audience(Optional<String> audience) {
            Utils.checkNotNull(audience, "audience");
            this.audience = audience;
            return this;
        }

        public Builder authorizedParty(String authorizedParty) {
            Utils.checkNotNull(authorizedParty, "authorizedParty");
            this.authorizedParties.add(authorizedParty);
            return this;
        }

        public Builder authorizedParties(Collection<String> authorizedParties) {
            Utils.checkNotNull(authorizedParties, "authorizedParties");
            this.authorizedParties.addAll(authorizedParties);
            return this;
        }

        public Builder clockSkew(long duration, TimeUnit unit) {
            this.clockSkewInMs = unit.toMillis(duration);
            return this;
        }

        public Builder clockSkew(Optional<Long> duration, TimeUnit unit) {
            Utils.checkNotNull(this.clockSkewInMs, "clockSkewInMs");
            if (duration.isPresent()) {
                return this.clockSkew(duration.get(), unit);
            }
            return this.clockSkew(5000L, TimeUnit.MILLISECONDS);
        }

        public Builder apiUrl(String apiUrl) {
            Utils.checkNotNull(apiUrl, "apiUrl");
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder apiUrl(Optional<String> apiUrl) {
            Utils.checkNotNull(apiUrl, "apiUrl");
            this.apiUrl = apiUrl.orElse(VerifyTokenOptions.DEFAULT_API_URL);
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            Utils.checkNotNull(apiVersion, "apiVersion");
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiVersion(Optional<String> apiVersion) {
            Utils.checkNotNull(apiVersion, "apiVersion");
            this.apiVersion = apiVersion.orElse(VerifyTokenOptions.DEFAULT_API_VERSION);
            return this;
        }

        public VerifyTokenOptions build() {
            return new VerifyTokenOptions(this.secretKey, this.jwtKey, this.audience, this.authorizedParties, Optional.of(this.clockSkewInMs), Optional.of(this.apiUrl), Optional.of(this.apiVersion));
        }
    }
}

