/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Object;
import com.clerk.backend_api.models.components.Session;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Client {
    @JsonProperty(value="object")
    private Object object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="session_ids")
    private List<String> sessionIds;
    @JsonProperty(value="sessions")
    private List<Session> sessions;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="sign_in_id")
    private Optional<String> signInId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="sign_up_id")
    private Optional<String> signUpId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_active_session_id")
    private Optional<String> lastActiveSessionId;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="created_at")
    private long createdAt;

    @JsonCreator
    public Client(@JsonProperty(value="object") Object object, @JsonProperty(value="id") String id, @JsonProperty(value="session_ids") List<String> sessionIds, @JsonProperty(value="sessions") List<Session> sessions, @JsonProperty(value="sign_in_id") Optional<String> signInId, @JsonProperty(value="sign_up_id") Optional<String> signUpId, @JsonProperty(value="last_active_session_id") Optional<String> lastActiveSessionId, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="created_at") long createdAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(sessionIds, "sessionIds");
        Utils.checkNotNull(sessions, "sessions");
        Utils.checkNotNull(signInId, "signInId");
        Utils.checkNotNull(signUpId, "signUpId");
        Utils.checkNotNull(lastActiveSessionId, "lastActiveSessionId");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        this.object = object;
        this.id = id;
        this.sessionIds = sessionIds;
        this.sessions = sessions;
        this.signInId = signInId;
        this.signUpId = signUpId;
        this.lastActiveSessionId = lastActiveSessionId;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
    }

    public Client(Object object, String id, List<String> sessionIds, List<Session> sessions, long updatedAt, long createdAt) {
        this(object, id, sessionIds, sessions, Optional.empty(), Optional.empty(), Optional.empty(), updatedAt, createdAt);
    }

    @JsonIgnore
    public Object object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public List<String> sessionIds() {
        return this.sessionIds;
    }

    @JsonIgnore
    public List<Session> sessions() {
        return this.sessions;
    }

    @JsonIgnore
    public Optional<String> signInId() {
        return this.signInId;
    }

    @JsonIgnore
    public Optional<String> signUpId() {
        return this.signUpId;
    }

    @JsonIgnore
    public Optional<String> lastActiveSessionId() {
        return this.lastActiveSessionId;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Client withObject(Object object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Client withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Client withSessionIds(List<String> sessionIds) {
        Utils.checkNotNull(sessionIds, "sessionIds");
        this.sessionIds = sessionIds;
        return this;
    }

    public Client withSessions(List<Session> sessions) {
        Utils.checkNotNull(sessions, "sessions");
        this.sessions = sessions;
        return this;
    }

    public Client withSignInId(String signInId) {
        Utils.checkNotNull(signInId, "signInId");
        this.signInId = Optional.ofNullable(signInId);
        return this;
    }

    public Client withSignInId(Optional<String> signInId) {
        Utils.checkNotNull(signInId, "signInId");
        this.signInId = signInId;
        return this;
    }

    public Client withSignUpId(String signUpId) {
        Utils.checkNotNull(signUpId, "signUpId");
        this.signUpId = Optional.ofNullable(signUpId);
        return this;
    }

    public Client withSignUpId(Optional<String> signUpId) {
        Utils.checkNotNull(signUpId, "signUpId");
        this.signUpId = signUpId;
        return this;
    }

    public Client withLastActiveSessionId(String lastActiveSessionId) {
        Utils.checkNotNull(lastActiveSessionId, "lastActiveSessionId");
        this.lastActiveSessionId = Optional.ofNullable(lastActiveSessionId);
        return this;
    }

    public Client withLastActiveSessionId(Optional<String> lastActiveSessionId) {
        Utils.checkNotNull(lastActiveSessionId, "lastActiveSessionId");
        this.lastActiveSessionId = lastActiveSessionId;
        return this;
    }

    public Client withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public Client withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client other = (Client)o;
        return Objects.deepEquals((java.lang.Object)this.object, (java.lang.Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.sessionIds, other.sessionIds) && Objects.deepEquals(this.sessions, other.sessions) && Objects.deepEquals(this.signInId, other.signInId) && Objects.deepEquals(this.signUpId, other.signUpId) && Objects.deepEquals(this.lastActiveSessionId, other.lastActiveSessionId) && Objects.deepEquals(this.updatedAt, other.updatedAt) && Objects.deepEquals(this.createdAt, other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new java.lang.Object[]{this.object, this.id, this.sessionIds, this.sessions, this.signInId, this.signUpId, this.lastActiveSessionId, this.updatedAt, this.createdAt});
    }

    public String toString() {
        return Utils.toString(Client.class, new java.lang.Object[]{"object", this.object, "id", this.id, "sessionIds", this.sessionIds, "sessions", this.sessions, "signInId", this.signInId, "signUpId", this.signUpId, "lastActiveSessionId", this.lastActiveSessionId, "updatedAt", this.updatedAt, "createdAt", this.createdAt});
    }

    public static final class Builder {
        private Object object;
        private String id;
        private List<String> sessionIds;
        private List<Session> sessions;
        private Optional<String> signInId = Optional.empty();
        private Optional<String> signUpId = Optional.empty();
        private Optional<String> lastActiveSessionId = Optional.empty();
        private Long updatedAt;
        private Long createdAt;

        private Builder() {
        }

        public Builder object(Object object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder sessionIds(List<String> sessionIds) {
            Utils.checkNotNull(sessionIds, "sessionIds");
            this.sessionIds = sessionIds;
            return this;
        }

        public Builder sessions(List<Session> sessions) {
            Utils.checkNotNull(sessions, "sessions");
            this.sessions = sessions;
            return this;
        }

        public Builder signInId(String signInId) {
            Utils.checkNotNull(signInId, "signInId");
            this.signInId = Optional.ofNullable(signInId);
            return this;
        }

        public Builder signInId(Optional<String> signInId) {
            Utils.checkNotNull(signInId, "signInId");
            this.signInId = signInId;
            return this;
        }

        public Builder signUpId(String signUpId) {
            Utils.checkNotNull(signUpId, "signUpId");
            this.signUpId = Optional.ofNullable(signUpId);
            return this;
        }

        public Builder signUpId(Optional<String> signUpId) {
            Utils.checkNotNull(signUpId, "signUpId");
            this.signUpId = signUpId;
            return this;
        }

        public Builder lastActiveSessionId(String lastActiveSessionId) {
            Utils.checkNotNull(lastActiveSessionId, "lastActiveSessionId");
            this.lastActiveSessionId = Optional.ofNullable(lastActiveSessionId);
            return this;
        }

        public Builder lastActiveSessionId(Optional<String> lastActiveSessionId) {
            Utils.checkNotNull(lastActiveSessionId, "lastActiveSessionId");
            this.lastActiveSessionId = lastActiveSessionId;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Client build() {
            return new Client(this.object, this.id, this.sessionIds, this.sessions, this.signInId, this.signUpId, this.lastActiveSessionId, this.updatedAt, this.createdAt);
        }
    }
}

