/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CNameTarget;
import com.clerk.backend_api.models.components.DomainObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Domain {
    @JsonProperty(value="object")
    private DomainObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="is_satellite")
    private boolean isSatellite;
    @JsonProperty(value="frontend_api_url")
    private String frontendApiUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="accounts_portal_url")
    private JsonNullable<String> accountsPortalUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="proxy_url")
    private JsonNullable<String> proxyUrl;
    @JsonProperty(value="development_origin")
    private String developmentOrigin;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="cname_targets")
    private JsonNullable<? extends List<CNameTarget>> cnameTargets;

    @JsonCreator
    public Domain(@JsonProperty(value="object") DomainObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="is_satellite") boolean isSatellite, @JsonProperty(value="frontend_api_url") String frontendApiUrl, @JsonProperty(value="accounts_portal_url") JsonNullable<String> accountsPortalUrl, @JsonProperty(value="proxy_url") JsonNullable<String> proxyUrl, @JsonProperty(value="development_origin") String developmentOrigin, @JsonProperty(value="cname_targets") JsonNullable<? extends List<CNameTarget>> cnameTargets) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(isSatellite, "isSatellite");
        Utils.checkNotNull(frontendApiUrl, "frontendApiUrl");
        Utils.checkNotNull(accountsPortalUrl, "accountsPortalUrl");
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        Utils.checkNotNull(developmentOrigin, "developmentOrigin");
        Utils.checkNotNull(cnameTargets, "cnameTargets");
        this.object = object;
        this.id = id;
        this.name = name;
        this.isSatellite = isSatellite;
        this.frontendApiUrl = frontendApiUrl;
        this.accountsPortalUrl = accountsPortalUrl;
        this.proxyUrl = proxyUrl;
        this.developmentOrigin = developmentOrigin;
        this.cnameTargets = cnameTargets;
    }

    public Domain(DomainObject object, String id, String name, boolean isSatellite, String frontendApiUrl, String developmentOrigin) {
        this(object, id, name, isSatellite, frontendApiUrl, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), developmentOrigin, (JsonNullable<? extends List<CNameTarget>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public DomainObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public boolean isSatellite() {
        return this.isSatellite;
    }

    @JsonIgnore
    public String frontendApiUrl() {
        return this.frontendApiUrl;
    }

    @JsonIgnore
    public JsonNullable<String> accountsPortalUrl() {
        return this.accountsPortalUrl;
    }

    @JsonIgnore
    public JsonNullable<String> proxyUrl() {
        return this.proxyUrl;
    }

    @JsonIgnore
    public String developmentOrigin() {
        return this.developmentOrigin;
    }

    @JsonIgnore
    public JsonNullable<List<CNameTarget>> cnameTargets() {
        return this.cnameTargets;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Domain withObject(DomainObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Domain withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Domain withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Domain withIsSatellite(boolean isSatellite) {
        Utils.checkNotNull(isSatellite, "isSatellite");
        this.isSatellite = isSatellite;
        return this;
    }

    public Domain withFrontendApiUrl(String frontendApiUrl) {
        Utils.checkNotNull(frontendApiUrl, "frontendApiUrl");
        this.frontendApiUrl = frontendApiUrl;
        return this;
    }

    public Domain withAccountsPortalUrl(String accountsPortalUrl) {
        Utils.checkNotNull(accountsPortalUrl, "accountsPortalUrl");
        this.accountsPortalUrl = JsonNullable.of((Object)accountsPortalUrl);
        return this;
    }

    public Domain withAccountsPortalUrl(JsonNullable<String> accountsPortalUrl) {
        Utils.checkNotNull(accountsPortalUrl, "accountsPortalUrl");
        this.accountsPortalUrl = accountsPortalUrl;
        return this;
    }

    public Domain withProxyUrl(String proxyUrl) {
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.proxyUrl = JsonNullable.of((Object)proxyUrl);
        return this;
    }

    public Domain withProxyUrl(JsonNullable<String> proxyUrl) {
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.proxyUrl = proxyUrl;
        return this;
    }

    public Domain withDevelopmentOrigin(String developmentOrigin) {
        Utils.checkNotNull(developmentOrigin, "developmentOrigin");
        this.developmentOrigin = developmentOrigin;
        return this;
    }

    public Domain withCnameTargets(List<CNameTarget> cnameTargets) {
        Utils.checkNotNull(cnameTargets, "cnameTargets");
        this.cnameTargets = JsonNullable.of(cnameTargets);
        return this;
    }

    public Domain withCnameTargets(JsonNullable<? extends List<CNameTarget>> cnameTargets) {
        Utils.checkNotNull(cnameTargets, "cnameTargets");
        this.cnameTargets = cnameTargets;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain other = (Domain)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.isSatellite, other.isSatellite) && Objects.deepEquals(this.frontendApiUrl, other.frontendApiUrl) && Objects.deepEquals(this.accountsPortalUrl, other.accountsPortalUrl) && Objects.deepEquals(this.proxyUrl, other.proxyUrl) && Objects.deepEquals(this.developmentOrigin, other.developmentOrigin) && Objects.deepEquals(this.cnameTargets, other.cnameTargets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.name, this.isSatellite, this.frontendApiUrl, this.accountsPortalUrl, this.proxyUrl, this.developmentOrigin, this.cnameTargets});
    }

    public String toString() {
        return Utils.toString(Domain.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "isSatellite", this.isSatellite, "frontendApiUrl", this.frontendApiUrl, "accountsPortalUrl", this.accountsPortalUrl, "proxyUrl", this.proxyUrl, "developmentOrigin", this.developmentOrigin, "cnameTargets", this.cnameTargets});
    }

    public static final class Builder {
        private DomainObject object;
        private String id;
        private String name;
        private Boolean isSatellite;
        private String frontendApiUrl;
        private JsonNullable<String> accountsPortalUrl = JsonNullable.undefined();
        private JsonNullable<String> proxyUrl = JsonNullable.undefined();
        private String developmentOrigin;
        private JsonNullable<? extends List<CNameTarget>> cnameTargets = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(DomainObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder isSatellite(boolean isSatellite) {
            Utils.checkNotNull(isSatellite, "isSatellite");
            this.isSatellite = isSatellite;
            return this;
        }

        public Builder frontendApiUrl(String frontendApiUrl) {
            Utils.checkNotNull(frontendApiUrl, "frontendApiUrl");
            this.frontendApiUrl = frontendApiUrl;
            return this;
        }

        public Builder accountsPortalUrl(String accountsPortalUrl) {
            Utils.checkNotNull(accountsPortalUrl, "accountsPortalUrl");
            this.accountsPortalUrl = JsonNullable.of((Object)accountsPortalUrl);
            return this;
        }

        public Builder accountsPortalUrl(JsonNullable<String> accountsPortalUrl) {
            Utils.checkNotNull(accountsPortalUrl, "accountsPortalUrl");
            this.accountsPortalUrl = accountsPortalUrl;
            return this;
        }

        public Builder proxyUrl(String proxyUrl) {
            Utils.checkNotNull(proxyUrl, "proxyUrl");
            this.proxyUrl = JsonNullable.of((Object)proxyUrl);
            return this;
        }

        public Builder proxyUrl(JsonNullable<String> proxyUrl) {
            Utils.checkNotNull(proxyUrl, "proxyUrl");
            this.proxyUrl = proxyUrl;
            return this;
        }

        public Builder developmentOrigin(String developmentOrigin) {
            Utils.checkNotNull(developmentOrigin, "developmentOrigin");
            this.developmentOrigin = developmentOrigin;
            return this;
        }

        public Builder cnameTargets(List<CNameTarget> cnameTargets) {
            Utils.checkNotNull(cnameTargets, "cnameTargets");
            this.cnameTargets = JsonNullable.of(cnameTargets);
            return this;
        }

        public Builder cnameTargets(JsonNullable<? extends List<CNameTarget>> cnameTargets) {
            Utils.checkNotNull(cnameTargets, "cnameTargets");
            this.cnameTargets = cnameTargets;
            return this;
        }

        public Domain build() {
            return new Domain(this.object, this.id, this.name, this.isSatellite, this.frontendApiUrl, this.accountsPortalUrl, this.proxyUrl, this.developmentOrigin, this.cnameTargets);
        }
    }
}

