/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.EmailAddressObject;
import com.clerk.backend_api.models.components.IdentificationLink;
import com.clerk.backend_api.models.components.Verification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class EmailAddress {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonProperty(value="object")
    private EmailAddressObject object;
    @JsonProperty(value="email_address")
    private String emailAddress;
    @JsonProperty(value="reserved")
    private boolean reserved;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification")
    private Optional<? extends Verification> verification;
    @JsonProperty(value="linked_to")
    private List<IdentificationLink> linkedTo;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="matches_sso_connection")
    private Optional<Boolean> matchesSsoConnection;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public EmailAddress(@JsonProperty(value="id") Optional<String> id, @JsonProperty(value="object") EmailAddressObject object, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="reserved") boolean reserved, @JsonProperty(value="verification") Optional<? extends Verification> verification, @JsonProperty(value="linked_to") List<IdentificationLink> linkedTo, @JsonProperty(value="matches_sso_connection") Optional<Boolean> matchesSsoConnection, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(reserved, "reserved");
        Utils.checkNotNull(verification, "verification");
        Utils.checkNotNull(linkedTo, "linkedTo");
        Utils.checkNotNull(matchesSsoConnection, "matchesSsoConnection");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.object = object;
        this.emailAddress = emailAddress;
        this.reserved = reserved;
        this.verification = verification;
        this.linkedTo = linkedTo;
        this.matchesSsoConnection = matchesSsoConnection;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public EmailAddress(EmailAddressObject object, String emailAddress, boolean reserved, List<IdentificationLink> linkedTo, long createdAt, long updatedAt) {
        this(Optional.empty(), object, emailAddress, reserved, Optional.empty(), linkedTo, Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public EmailAddressObject object() {
        return this.object;
    }

    @JsonIgnore
    public String emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public boolean reserved() {
        return this.reserved;
    }

    @JsonIgnore
    public Optional<Verification> verification() {
        return this.verification;
    }

    @JsonIgnore
    public List<IdentificationLink> linkedTo() {
        return this.linkedTo;
    }

    @JsonIgnore
    public Optional<Boolean> matchesSsoConnection() {
        return this.matchesSsoConnection;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public EmailAddress withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public EmailAddress withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public EmailAddress withObject(EmailAddressObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public EmailAddress withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public EmailAddress withReserved(boolean reserved) {
        Utils.checkNotNull(reserved, "reserved");
        this.reserved = reserved;
        return this;
    }

    public EmailAddress withVerification(Verification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = Optional.ofNullable(verification);
        return this;
    }

    public EmailAddress withVerification(Optional<? extends Verification> verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    public EmailAddress withLinkedTo(List<IdentificationLink> linkedTo) {
        Utils.checkNotNull(linkedTo, "linkedTo");
        this.linkedTo = linkedTo;
        return this;
    }

    public EmailAddress withMatchesSsoConnection(boolean matchesSsoConnection) {
        Utils.checkNotNull(matchesSsoConnection, "matchesSsoConnection");
        this.matchesSsoConnection = Optional.ofNullable(matchesSsoConnection);
        return this;
    }

    public EmailAddress withMatchesSsoConnection(Optional<Boolean> matchesSsoConnection) {
        Utils.checkNotNull(matchesSsoConnection, "matchesSsoConnection");
        this.matchesSsoConnection = matchesSsoConnection;
        return this;
    }

    public EmailAddress withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public EmailAddress withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAddress other = (EmailAddress)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.object, other.object) && Objects.deepEquals(this.emailAddress, other.emailAddress) && Objects.deepEquals(this.reserved, other.reserved) && Objects.deepEquals(this.verification, other.verification) && Objects.deepEquals(this.linkedTo, other.linkedTo) && Objects.deepEquals(this.matchesSsoConnection, other.matchesSsoConnection) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.object, this.emailAddress, this.reserved, this.verification, this.linkedTo, this.matchesSsoConnection, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return Utils.toString(EmailAddress.class, "id", this.id, "object", this.object, "emailAddress", this.emailAddress, "reserved", this.reserved, "verification", this.verification, "linkedTo", this.linkedTo, "matchesSsoConnection", this.matchesSsoConnection, "createdAt", this.createdAt, "updatedAt", this.updatedAt);
    }

    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private EmailAddressObject object;
        private String emailAddress;
        private Boolean reserved;
        private Optional<? extends Verification> verification = Optional.empty();
        private List<IdentificationLink> linkedTo;
        private Optional<Boolean> matchesSsoConnection = Optional.empty();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(EmailAddressObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder reserved(boolean reserved) {
            Utils.checkNotNull(reserved, "reserved");
            this.reserved = reserved;
            return this;
        }

        public Builder verification(Verification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = Optional.ofNullable(verification);
            return this;
        }

        public Builder verification(Optional<? extends Verification> verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        public Builder linkedTo(List<IdentificationLink> linkedTo) {
            Utils.checkNotNull(linkedTo, "linkedTo");
            this.linkedTo = linkedTo;
            return this;
        }

        public Builder matchesSsoConnection(boolean matchesSsoConnection) {
            Utils.checkNotNull(matchesSsoConnection, "matchesSsoConnection");
            this.matchesSsoConnection = Optional.ofNullable(matchesSsoConnection);
            return this;
        }

        public Builder matchesSsoConnection(Optional<Boolean> matchesSsoConnection) {
            Utils.checkNotNull(matchesSsoConnection, "matchesSsoConnection");
            this.matchesSsoConnection = matchesSsoConnection;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public EmailAddress build() {
            return new EmailAddress(this.id, this.object, this.emailAddress, this.reserved, this.verification, this.linkedTo, this.matchesSsoConnection, this.createdAt, this.updatedAt);
        }
    }
}

