/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.InstanceRestrictionsObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class InstanceRestrictions {
    @JsonProperty(value="object")
    private InstanceRestrictionsObject object;
    @JsonProperty(value="allowlist")
    private boolean allowlist;
    @JsonProperty(value="blocklist")
    private boolean blocklist;
    @JsonProperty(value="block_email_subaddresses")
    private boolean blockEmailSubaddresses;
    @JsonProperty(value="block_disposable_email_domains")
    private boolean blockDisposableEmailDomains;
    @JsonProperty(value="ignore_dots_for_gmail_addresses")
    private boolean ignoreDotsForGmailAddresses;

    @JsonCreator
    public InstanceRestrictions(@JsonProperty(value="object") InstanceRestrictionsObject object, @JsonProperty(value="allowlist") boolean allowlist, @JsonProperty(value="blocklist") boolean blocklist, @JsonProperty(value="block_email_subaddresses") boolean blockEmailSubaddresses, @JsonProperty(value="block_disposable_email_domains") boolean blockDisposableEmailDomains, @JsonProperty(value="ignore_dots_for_gmail_addresses") boolean ignoreDotsForGmailAddresses) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(allowlist, "allowlist");
        Utils.checkNotNull(blocklist, "blocklist");
        Utils.checkNotNull(blockEmailSubaddresses, "blockEmailSubaddresses");
        Utils.checkNotNull(blockDisposableEmailDomains, "blockDisposableEmailDomains");
        Utils.checkNotNull(ignoreDotsForGmailAddresses, "ignoreDotsForGmailAddresses");
        this.object = object;
        this.allowlist = allowlist;
        this.blocklist = blocklist;
        this.blockEmailSubaddresses = blockEmailSubaddresses;
        this.blockDisposableEmailDomains = blockDisposableEmailDomains;
        this.ignoreDotsForGmailAddresses = ignoreDotsForGmailAddresses;
    }

    @JsonIgnore
    public InstanceRestrictionsObject object() {
        return this.object;
    }

    @JsonIgnore
    public boolean allowlist() {
        return this.allowlist;
    }

    @JsonIgnore
    public boolean blocklist() {
        return this.blocklist;
    }

    @JsonIgnore
    public boolean blockEmailSubaddresses() {
        return this.blockEmailSubaddresses;
    }

    @JsonIgnore
    public boolean blockDisposableEmailDomains() {
        return this.blockDisposableEmailDomains;
    }

    @JsonIgnore
    public boolean ignoreDotsForGmailAddresses() {
        return this.ignoreDotsForGmailAddresses;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public InstanceRestrictions withObject(InstanceRestrictionsObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public InstanceRestrictions withAllowlist(boolean allowlist) {
        Utils.checkNotNull(allowlist, "allowlist");
        this.allowlist = allowlist;
        return this;
    }

    public InstanceRestrictions withBlocklist(boolean blocklist) {
        Utils.checkNotNull(blocklist, "blocklist");
        this.blocklist = blocklist;
        return this;
    }

    public InstanceRestrictions withBlockEmailSubaddresses(boolean blockEmailSubaddresses) {
        Utils.checkNotNull(blockEmailSubaddresses, "blockEmailSubaddresses");
        this.blockEmailSubaddresses = blockEmailSubaddresses;
        return this;
    }

    public InstanceRestrictions withBlockDisposableEmailDomains(boolean blockDisposableEmailDomains) {
        Utils.checkNotNull(blockDisposableEmailDomains, "blockDisposableEmailDomains");
        this.blockDisposableEmailDomains = blockDisposableEmailDomains;
        return this;
    }

    public InstanceRestrictions withIgnoreDotsForGmailAddresses(boolean ignoreDotsForGmailAddresses) {
        Utils.checkNotNull(ignoreDotsForGmailAddresses, "ignoreDotsForGmailAddresses");
        this.ignoreDotsForGmailAddresses = ignoreDotsForGmailAddresses;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceRestrictions other = (InstanceRestrictions)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.allowlist, other.allowlist) && Objects.deepEquals(this.blocklist, other.blocklist) && Objects.deepEquals(this.blockEmailSubaddresses, other.blockEmailSubaddresses) && Objects.deepEquals(this.blockDisposableEmailDomains, other.blockDisposableEmailDomains) && Objects.deepEquals(this.ignoreDotsForGmailAddresses, other.ignoreDotsForGmailAddresses);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.allowlist, this.blocklist, this.blockEmailSubaddresses, this.blockDisposableEmailDomains, this.ignoreDotsForGmailAddresses});
    }

    public String toString() {
        return Utils.toString(InstanceRestrictions.class, new Object[]{"object", this.object, "allowlist", this.allowlist, "blocklist", this.blocklist, "blockEmailSubaddresses", this.blockEmailSubaddresses, "blockDisposableEmailDomains", this.blockDisposableEmailDomains, "ignoreDotsForGmailAddresses", this.ignoreDotsForGmailAddresses});
    }

    public static final class Builder {
        private InstanceRestrictionsObject object;
        private Boolean allowlist;
        private Boolean blocklist;
        private Boolean blockEmailSubaddresses;
        private Boolean blockDisposableEmailDomains;
        private Boolean ignoreDotsForGmailAddresses;

        private Builder() {
        }

        public Builder object(InstanceRestrictionsObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder allowlist(boolean allowlist) {
            Utils.checkNotNull(allowlist, "allowlist");
            this.allowlist = allowlist;
            return this;
        }

        public Builder blocklist(boolean blocklist) {
            Utils.checkNotNull(blocklist, "blocklist");
            this.blocklist = blocklist;
            return this;
        }

        public Builder blockEmailSubaddresses(boolean blockEmailSubaddresses) {
            Utils.checkNotNull(blockEmailSubaddresses, "blockEmailSubaddresses");
            this.blockEmailSubaddresses = blockEmailSubaddresses;
            return this;
        }

        public Builder blockDisposableEmailDomains(boolean blockDisposableEmailDomains) {
            Utils.checkNotNull(blockDisposableEmailDomains, "blockDisposableEmailDomains");
            this.blockDisposableEmailDomains = blockDisposableEmailDomains;
            return this;
        }

        public Builder ignoreDotsForGmailAddresses(boolean ignoreDotsForGmailAddresses) {
            Utils.checkNotNull(ignoreDotsForGmailAddresses, "ignoreDotsForGmailAddresses");
            this.ignoreDotsForGmailAddresses = ignoreDotsForGmailAddresses;
            return this;
        }

        public InstanceRestrictions build() {
            return new InstanceRestrictions(this.object, this.allowlist, this.blocklist, this.blockEmailSubaddresses, this.blockDisposableEmailDomains, this.ignoreDotsForGmailAddresses);
        }
    }
}

