/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.InvitationRevokedObject;
import com.clerk.backend_api.models.components.InvitationRevokedStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class InvitationRevoked {
    @JsonProperty(value="object")
    private InvitationRevokedObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="email_address")
    private String emailAddress;
    @JsonProperty(value="public_metadata")
    private Map<String, Object> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="revoked")
    private Optional<Boolean> revoked;
    @JsonProperty(value="status")
    private InvitationRevokedStatus status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private Optional<String> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expires_at")
    private JsonNullable<Long> expiresAt;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public InvitationRevoked(@JsonProperty(value="object") InvitationRevokedObject object, @JsonProperty(value="id") String id, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="public_metadata") Map<String, Object> publicMetadata, @JsonProperty(value="revoked") Optional<Boolean> revoked, @JsonProperty(value="status") InvitationRevokedStatus status, @JsonProperty(value="url") Optional<String> url, @JsonProperty(value="expires_at") JsonNullable<Long> expiresAt, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(emailAddress, "emailAddress");
        publicMetadata = Utils.emptyMapIfNull(publicMetadata);
        Utils.checkNotNull(revoked, "revoked");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(expiresAt, "expiresAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.emailAddress = emailAddress;
        this.publicMetadata = publicMetadata;
        this.revoked = revoked;
        this.status = status;
        this.url = url;
        this.expiresAt = expiresAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public InvitationRevoked(InvitationRevokedObject object, String id, String emailAddress, Map<String, Object> publicMetadata, InvitationRevokedStatus status, long createdAt, long updatedAt) {
        this(object, id, emailAddress, publicMetadata, Optional.empty(), status, Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined(), createdAt, updatedAt);
    }

    @JsonIgnore
    public InvitationRevokedObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public Map<String, Object> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Optional<Boolean> revoked() {
        return this.revoked;
    }

    @JsonIgnore
    public InvitationRevokedStatus status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<Long> expiresAt() {
        return this.expiresAt;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public InvitationRevoked withObject(InvitationRevokedObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public InvitationRevoked withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public InvitationRevoked withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public InvitationRevoked withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public InvitationRevoked withRevoked(boolean revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = Optional.ofNullable(revoked);
        return this;
    }

    public InvitationRevoked withRevoked(Optional<Boolean> revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = revoked;
        return this;
    }

    public InvitationRevoked withStatus(InvitationRevokedStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public InvitationRevoked withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = Optional.ofNullable(url);
        return this;
    }

    public InvitationRevoked withUrl(Optional<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public InvitationRevoked withExpiresAt(long expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = JsonNullable.of((Object)expiresAt);
        return this;
    }

    public InvitationRevoked withExpiresAt(JsonNullable<Long> expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = expiresAt;
        return this;
    }

    public InvitationRevoked withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public InvitationRevoked withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvitationRevoked other = (InvitationRevoked)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.emailAddress, other.emailAddress) && Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.revoked, other.revoked) && Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.url, other.url) && Objects.deepEquals(this.expiresAt, other.expiresAt) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.emailAddress, this.publicMetadata, this.revoked, this.status, this.url, this.expiresAt, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(InvitationRevoked.class, new Object[]{"object", this.object, "id", this.id, "emailAddress", this.emailAddress, "publicMetadata", this.publicMetadata, "revoked", this.revoked, "status", this.status, "url", this.url, "expiresAt", this.expiresAt, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private InvitationRevokedObject object;
        private String id;
        private String emailAddress;
        private Map<String, Object> publicMetadata;
        private Optional<Boolean> revoked = Optional.empty();
        private InvitationRevokedStatus status;
        private Optional<String> url = Optional.empty();
        private JsonNullable<Long> expiresAt = JsonNullable.undefined();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(InvitationRevokedObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder revoked(boolean revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = Optional.ofNullable(revoked);
            return this;
        }

        public Builder revoked(Optional<Boolean> revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = revoked;
            return this;
        }

        public Builder status(InvitationRevokedStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = Optional.ofNullable(url);
            return this;
        }

        public Builder url(Optional<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder expiresAt(long expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = JsonNullable.of((Object)expiresAt);
            return this;
        }

        public Builder expiresAt(JsonNullable<Long> expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public InvitationRevoked build() {
            return new InvitationRevoked(this.object, this.id, this.emailAddress, this.publicMetadata, this.revoked, this.status, this.url, this.expiresAt, this.createdAt, this.updatedAt);
        }
    }
}

