/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Claims;
import com.clerk.backend_api.models.components.JWTTemplateObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class JWTTemplate {
    @JsonProperty(value="object")
    private JWTTemplateObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="claims")
    private Claims claims;
    @JsonProperty(value="lifetime")
    private long lifetime;
    @JsonProperty(value="allowed_clock_skew")
    private long allowedClockSkew;
    @JsonProperty(value="custom_signing_key")
    private boolean customSigningKey;
    @JsonProperty(value="signing_algorithm")
    private String signingAlgorithm;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public JWTTemplate(@JsonProperty(value="object") JWTTemplateObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="claims") Claims claims, @JsonProperty(value="lifetime") long lifetime, @JsonProperty(value="allowed_clock_skew") long allowedClockSkew, @JsonProperty(value="custom_signing_key") boolean customSigningKey, @JsonProperty(value="signing_algorithm") String signingAlgorithm, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(claims, "claims");
        Utils.checkNotNull(lifetime, "lifetime");
        Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
        Utils.checkNotNull(customSigningKey, "customSigningKey");
        Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.name = name;
        this.claims = claims;
        this.lifetime = lifetime;
        this.allowedClockSkew = allowedClockSkew;
        this.customSigningKey = customSigningKey;
        this.signingAlgorithm = signingAlgorithm;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonIgnore
    public JWTTemplateObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public Claims claims() {
        return this.claims;
    }

    @JsonIgnore
    public long lifetime() {
        return this.lifetime;
    }

    @JsonIgnore
    public long allowedClockSkew() {
        return this.allowedClockSkew;
    }

    @JsonIgnore
    public boolean customSigningKey() {
        return this.customSigningKey;
    }

    @JsonIgnore
    public String signingAlgorithm() {
        return this.signingAlgorithm;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public JWTTemplate withObject(JWTTemplateObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public JWTTemplate withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public JWTTemplate withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public JWTTemplate withClaims(Claims claims) {
        Utils.checkNotNull(claims, "claims");
        this.claims = claims;
        return this;
    }

    public JWTTemplate withLifetime(long lifetime) {
        Utils.checkNotNull(lifetime, "lifetime");
        this.lifetime = lifetime;
        return this;
    }

    public JWTTemplate withAllowedClockSkew(long allowedClockSkew) {
        Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
        this.allowedClockSkew = allowedClockSkew;
        return this;
    }

    public JWTTemplate withCustomSigningKey(boolean customSigningKey) {
        Utils.checkNotNull(customSigningKey, "customSigningKey");
        this.customSigningKey = customSigningKey;
        return this;
    }

    public JWTTemplate withSigningAlgorithm(String signingAlgorithm) {
        Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    public JWTTemplate withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public JWTTemplate withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTTemplate other = (JWTTemplate)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.claims, other.claims) && Objects.deepEquals(this.lifetime, other.lifetime) && Objects.deepEquals(this.allowedClockSkew, other.allowedClockSkew) && Objects.deepEquals(this.customSigningKey, other.customSigningKey) && Objects.deepEquals(this.signingAlgorithm, other.signingAlgorithm) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.name, this.claims, this.lifetime, this.allowedClockSkew, this.customSigningKey, this.signingAlgorithm, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(JWTTemplate.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "claims", this.claims, "lifetime", this.lifetime, "allowedClockSkew", this.allowedClockSkew, "customSigningKey", this.customSigningKey, "signingAlgorithm", this.signingAlgorithm, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private JWTTemplateObject object;
        private String id;
        private String name;
        private Claims claims;
        private Long lifetime;
        private Long allowedClockSkew;
        private Boolean customSigningKey;
        private String signingAlgorithm;
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(JWTTemplateObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder claims(Claims claims) {
            Utils.checkNotNull(claims, "claims");
            this.claims = claims;
            return this;
        }

        public Builder lifetime(long lifetime) {
            Utils.checkNotNull(lifetime, "lifetime");
            this.lifetime = lifetime;
            return this;
        }

        public Builder allowedClockSkew(long allowedClockSkew) {
            Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
            this.allowedClockSkew = allowedClockSkew;
            return this;
        }

        public Builder customSigningKey(boolean customSigningKey) {
            Utils.checkNotNull(customSigningKey, "customSigningKey");
            this.customSigningKey = customSigningKey;
            return this;
        }

        public Builder signingAlgorithm(String signingAlgorithm) {
            Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public JWTTemplate build() {
            return new JWTTemplate(this.object, this.id, this.name, this.claims, this.lifetime, this.allowedClockSkew, this.customSigningKey, this.signingAlgorithm, this.createdAt, this.updatedAt);
        }
    }
}

