/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class OTPVerificationStrategy {
    public static final OTPVerificationStrategy PHONE_CODE = new OTPVerificationStrategy("phone_code");
    public static final OTPVerificationStrategy EMAIL_CODE = new OTPVerificationStrategy("email_code");
    public static final OTPVerificationStrategy RESET_PASSWORD_EMAIL_CODE = new OTPVerificationStrategy("reset_password_email_code");
    private static final Map<String, OTPVerificationStrategy> values = OTPVerificationStrategy.createValuesMap();
    private static final Map<String, OTPVerificationStrategyEnum> enums = OTPVerificationStrategy.createEnumsMap();
    private final String value;

    private OTPVerificationStrategy(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OTPVerificationStrategy of(String value) {
        Class<OTPVerificationStrategy> clazz = OTPVerificationStrategy.class;
        synchronized (OTPVerificationStrategy.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new OTPVerificationStrategy((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<OTPVerificationStrategyEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OTPVerificationStrategy other = (OTPVerificationStrategy)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "OTPVerificationStrategy [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OTPVerificationStrategy[] values() {
        Class<OTPVerificationStrategy> clazz = OTPVerificationStrategy.class;
        synchronized (OTPVerificationStrategy.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new OTPVerificationStrategy[0]);
        }
    }

    private static final Map<String, OTPVerificationStrategy> createValuesMap() {
        LinkedHashMap<String, OTPVerificationStrategy> map = new LinkedHashMap<String, OTPVerificationStrategy>();
        map.put("phone_code", PHONE_CODE);
        map.put("email_code", EMAIL_CODE);
        map.put("reset_password_email_code", RESET_PASSWORD_EMAIL_CODE);
        return map;
    }

    private static final Map<String, OTPVerificationStrategyEnum> createEnumsMap() {
        HashMap<String, OTPVerificationStrategyEnum> map = new HashMap<String, OTPVerificationStrategyEnum>();
        map.put("phone_code", OTPVerificationStrategyEnum.PHONE_CODE);
        map.put("email_code", OTPVerificationStrategyEnum.EMAIL_CODE);
        map.put("reset_password_email_code", OTPVerificationStrategyEnum.RESET_PASSWORD_EMAIL_CODE);
        return map;
    }

    public static enum OTPVerificationStrategyEnum {
        PHONE_CODE("phone_code"),
        EMAIL_CODE("email_code"),
        RESET_PASSWORD_EMAIL_CODE("reset_password_email_code");

        private final String value;

        private OTPVerificationStrategyEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<OTPVerificationStrategy> {
        protected _Deserializer() {
            super(OTPVerificationStrategy.class);
        }

        public OTPVerificationStrategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return OTPVerificationStrategy.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<OTPVerificationStrategy> {
        protected _Serializer() {
            super(OTPVerificationStrategy.class);
        }

        public void serialize(OTPVerificationStrategy value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

