/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Strategy;
import com.clerk.backend_api.models.components.VerificationStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Otp {
    @JsonProperty(value="status")
    private VerificationStatus status;
    @JsonProperty(value="strategy")
    private Strategy strategy;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public Otp(@JsonProperty(value="status") VerificationStatus status, @JsonProperty(value="strategy") Strategy strategy, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="expire_at") Optional<Long> expireAt, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.status = status;
        this.strategy = strategy;
        this.attempts = attempts;
        this.expireAt = expireAt;
        this.verifiedAtClient = verifiedAtClient;
    }

    public Otp(VerificationStatus status, Strategy strategy) {
        this(status, strategy, Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public VerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public Strategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Otp withStatus(VerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Otp withStrategy(Strategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public Otp withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public Otp withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public Otp withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public Otp withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public Otp withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public Otp withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Otp other = (Otp)o;
        return Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.strategy, other.strategy) && Objects.deepEquals(this.attempts, other.attempts) && Objects.deepEquals(this.expireAt, other.expireAt) && Objects.deepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.strategy, this.attempts, this.expireAt, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(Otp.class, new Object[]{"status", this.status, "strategy", this.strategy, "attempts", this.attempts, "expireAt", this.expireAt, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private VerificationStatus status;
        private Strategy strategy;
        private Optional<Long> attempts = Optional.empty();
        private Optional<Long> expireAt = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder status(VerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(Strategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public Otp build() {
            return new Otp(this.status, this.strategy, this.attempts, this.expireAt, this.verifiedAtClient);
        }
    }
}

