/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.ClerkErrorErrorSAMLAccountMeta;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class SAMLErrorClerkError {
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="long_message")
    private String longMessage;
    @JsonProperty(value="code")
    private String code;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="meta")
    private Optional<? extends ClerkErrorErrorSAMLAccountMeta> meta;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="clerk_trace_id")
    private Optional<String> clerkTraceId;

    @JsonCreator
    public SAMLErrorClerkError(@JsonProperty(value="message") String message, @JsonProperty(value="long_message") String longMessage, @JsonProperty(value="code") String code, @JsonProperty(value="meta") Optional<? extends ClerkErrorErrorSAMLAccountMeta> meta, @JsonProperty(value="clerk_trace_id") Optional<String> clerkTraceId) {
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(longMessage, "longMessage");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(meta, "meta");
        Utils.checkNotNull(clerkTraceId, "clerkTraceId");
        this.message = message;
        this.longMessage = longMessage;
        this.code = code;
        this.meta = meta;
        this.clerkTraceId = clerkTraceId;
    }

    public SAMLErrorClerkError(String message, String longMessage, String code) {
        this(message, longMessage, code, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String message() {
        return this.message;
    }

    @JsonIgnore
    public String longMessage() {
        return this.longMessage;
    }

    @JsonIgnore
    public String code() {
        return this.code;
    }

    @JsonIgnore
    public Optional<ClerkErrorErrorSAMLAccountMeta> meta() {
        return this.meta;
    }

    @JsonIgnore
    public Optional<String> clerkTraceId() {
        return this.clerkTraceId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public SAMLErrorClerkError withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public SAMLErrorClerkError withLongMessage(String longMessage) {
        Utils.checkNotNull(longMessage, "longMessage");
        this.longMessage = longMessage;
        return this;
    }

    public SAMLErrorClerkError withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public SAMLErrorClerkError withMeta(ClerkErrorErrorSAMLAccountMeta meta) {
        Utils.checkNotNull(meta, "meta");
        this.meta = Optional.ofNullable(meta);
        return this;
    }

    public SAMLErrorClerkError withMeta(Optional<? extends ClerkErrorErrorSAMLAccountMeta> meta) {
        Utils.checkNotNull(meta, "meta");
        this.meta = meta;
        return this;
    }

    public SAMLErrorClerkError withClerkTraceId(String clerkTraceId) {
        Utils.checkNotNull(clerkTraceId, "clerkTraceId");
        this.clerkTraceId = Optional.ofNullable(clerkTraceId);
        return this;
    }

    public SAMLErrorClerkError withClerkTraceId(Optional<String> clerkTraceId) {
        Utils.checkNotNull(clerkTraceId, "clerkTraceId");
        this.clerkTraceId = clerkTraceId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLErrorClerkError other = (SAMLErrorClerkError)o;
        return Objects.deepEquals(this.message, other.message) && Objects.deepEquals(this.longMessage, other.longMessage) && Objects.deepEquals(this.code, other.code) && Objects.deepEquals(this.meta, other.meta) && Objects.deepEquals(this.clerkTraceId, other.clerkTraceId);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.longMessage, this.code, this.meta, this.clerkTraceId);
    }

    public String toString() {
        return Utils.toString(SAMLErrorClerkError.class, "message", this.message, "longMessage", this.longMessage, "code", this.code, "meta", this.meta, "clerkTraceId", this.clerkTraceId);
    }

    public static final class Builder {
        private String message;
        private String longMessage;
        private String code;
        private Optional<? extends ClerkErrorErrorSAMLAccountMeta> meta = Optional.empty();
        private Optional<String> clerkTraceId = Optional.empty();

        private Builder() {
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder longMessage(String longMessage) {
            Utils.checkNotNull(longMessage, "longMessage");
            this.longMessage = longMessage;
            return this;
        }

        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder meta(ClerkErrorErrorSAMLAccountMeta meta) {
            Utils.checkNotNull(meta, "meta");
            this.meta = Optional.ofNullable(meta);
            return this;
        }

        public Builder meta(Optional<? extends ClerkErrorErrorSAMLAccountMeta> meta) {
            Utils.checkNotNull(meta, "meta");
            this.meta = meta;
            return this;
        }

        public Builder clerkTraceId(String clerkTraceId) {
            Utils.checkNotNull(clerkTraceId, "clerkTraceId");
            this.clerkTraceId = Optional.ofNullable(clerkTraceId);
            return this;
        }

        public Builder clerkTraceId(Optional<String> clerkTraceId) {
            Utils.checkNotNull(clerkTraceId, "clerkTraceId");
            this.clerkTraceId = clerkTraceId;
            return this;
        }

        public SAMLErrorClerkError build() {
            return new SAMLErrorClerkError(this.message, this.longMessage, this.code, this.meta, this.clerkTraceId);
        }
    }
}

