/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.SAMLVerificationError;
import com.clerk.backend_api.models.components.SAMLVerificationStatus;
import com.clerk.backend_api.models.components.SAMLVerificationStrategy;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Saml {
    @JsonProperty(value="status")
    private SAMLVerificationStatus status;
    @JsonProperty(value="strategy")
    private SAMLVerificationStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="external_verification_redirect_url")
    private Optional<String> externalVerificationRedirectUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<? extends SAMLVerificationError> error;
    @JsonProperty(value="expire_at")
    private long expireAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public Saml(@JsonProperty(value="status") SAMLVerificationStatus status, @JsonProperty(value="strategy") SAMLVerificationStrategy strategy, @JsonProperty(value="external_verification_redirect_url") Optional<String> externalVerificationRedirectUrl, @JsonProperty(value="error") JsonNullable<? extends SAMLVerificationError> error, @JsonProperty(value="expire_at") long expireAt, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.status = status;
        this.strategy = strategy;
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        this.error = error;
        this.expireAt = expireAt;
        this.attempts = attempts;
        this.verifiedAtClient = verifiedAtClient;
    }

    public Saml(SAMLVerificationStatus status, SAMLVerificationStrategy strategy, long expireAt) {
        this(status, strategy, Optional.empty(), (JsonNullable<? extends SAMLVerificationError>)JsonNullable.undefined(), expireAt, Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public SAMLVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public SAMLVerificationStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Optional<String> externalVerificationRedirectUrl() {
        return this.externalVerificationRedirectUrl;
    }

    @JsonIgnore
    public JsonNullable<SAMLVerificationError> error() {
        return this.error;
    }

    @JsonIgnore
    public long expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Saml withStatus(SAMLVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Saml withStrategy(SAMLVerificationStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public Saml withExternalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = Optional.ofNullable(externalVerificationRedirectUrl);
        return this;
    }

    public Saml withExternalVerificationRedirectUrl(Optional<String> externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        return this;
    }

    public Saml withError(SAMLVerificationError error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public Saml withError(JsonNullable<? extends SAMLVerificationError> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public Saml withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public Saml withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public Saml withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public Saml withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public Saml withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Saml other = (Saml)o;
        return Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals((Object)this.strategy, (Object)other.strategy) && Objects.deepEquals(this.externalVerificationRedirectUrl, other.externalVerificationRedirectUrl) && Objects.deepEquals(this.error, other.error) && Objects.deepEquals(this.expireAt, other.expireAt) && Objects.deepEquals(this.attempts, other.attempts) && Objects.deepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(Saml.class, new Object[]{"status", this.status, "strategy", this.strategy, "externalVerificationRedirectUrl", this.externalVerificationRedirectUrl, "error", this.error, "expireAt", this.expireAt, "attempts", this.attempts, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private SAMLVerificationStatus status;
        private SAMLVerificationStrategy strategy;
        private Optional<String> externalVerificationRedirectUrl = Optional.empty();
        private JsonNullable<? extends SAMLVerificationError> error = JsonNullable.undefined();
        private Long expireAt;
        private Optional<Long> attempts = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder status(SAMLVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(SAMLVerificationStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder externalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = Optional.ofNullable(externalVerificationRedirectUrl);
            return this;
        }

        public Builder externalVerificationRedirectUrl(Optional<String> externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
            return this;
        }

        public Builder error(SAMLVerificationError error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<? extends SAMLVerificationError> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public Saml build() {
            return new Saml(this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient);
        }
    }
}

