/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Actor;
import com.clerk.backend_api.models.components.SessionActivityResponse;
import com.clerk.backend_api.models.components.SessionObject;
import com.clerk.backend_api.models.components.Status;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Session {
    @JsonProperty(value="object")
    private SessionObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="actor")
    private JsonNullable<? extends Actor> actor;
    @JsonProperty(value="status")
    private Status status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_active_organization_id")
    private JsonNullable<String> lastActiveOrganizationId;
    @JsonProperty(value="last_active_at")
    private long lastActiveAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="latest_activity")
    private JsonNullable<? extends SessionActivityResponse> latestActivity;
    @JsonProperty(value="expire_at")
    private long expireAt;
    @JsonProperty(value="abandon_at")
    private long abandonAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="created_at")
    private long createdAt;

    @JsonCreator
    public Session(@JsonProperty(value="object") SessionObject object, @JsonProperty(value="id") String id, @JsonProperty(value="user_id") String userId, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="actor") JsonNullable<? extends Actor> actor, @JsonProperty(value="status") Status status, @JsonProperty(value="last_active_organization_id") JsonNullable<String> lastActiveOrganizationId, @JsonProperty(value="last_active_at") long lastActiveAt, @JsonProperty(value="latest_activity") JsonNullable<? extends SessionActivityResponse> latestActivity, @JsonProperty(value="expire_at") long expireAt, @JsonProperty(value="abandon_at") long abandonAt, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="created_at") long createdAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(actor, "actor");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(lastActiveOrganizationId, "lastActiveOrganizationId");
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        Utils.checkNotNull(latestActivity, "latestActivity");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(abandonAt, "abandonAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        this.object = object;
        this.id = id;
        this.userId = userId;
        this.clientId = clientId;
        this.actor = actor;
        this.status = status;
        this.lastActiveOrganizationId = lastActiveOrganizationId;
        this.lastActiveAt = lastActiveAt;
        this.latestActivity = latestActivity;
        this.expireAt = expireAt;
        this.abandonAt = abandonAt;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
    }

    public Session(SessionObject object, String id, String userId, String clientId, Status status, long lastActiveAt, long expireAt, long abandonAt, long updatedAt, long createdAt) {
        this(object, id, userId, clientId, (JsonNullable<? extends Actor>)JsonNullable.undefined(), status, (JsonNullable<String>)JsonNullable.undefined(), lastActiveAt, (JsonNullable<? extends SessionActivityResponse>)JsonNullable.undefined(), expireAt, abandonAt, updatedAt, createdAt);
    }

    @JsonIgnore
    public SessionObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public JsonNullable<Actor> actor() {
        return this.actor;
    }

    @JsonIgnore
    public Status status() {
        return this.status;
    }

    @JsonIgnore
    public JsonNullable<String> lastActiveOrganizationId() {
        return this.lastActiveOrganizationId;
    }

    @JsonIgnore
    public long lastActiveAt() {
        return this.lastActiveAt;
    }

    @JsonIgnore
    public JsonNullable<SessionActivityResponse> latestActivity() {
        return this.latestActivity;
    }

    @JsonIgnore
    public long expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public long abandonAt() {
        return this.abandonAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Session withObject(SessionObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Session withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Session withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public Session withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public Session withActor(Actor actor) {
        Utils.checkNotNull(actor, "actor");
        this.actor = JsonNullable.of((Object)actor);
        return this;
    }

    public Session withActor(JsonNullable<? extends Actor> actor) {
        Utils.checkNotNull(actor, "actor");
        this.actor = actor;
        return this;
    }

    public Session withStatus(Status status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Session withLastActiveOrganizationId(String lastActiveOrganizationId) {
        Utils.checkNotNull(lastActiveOrganizationId, "lastActiveOrganizationId");
        this.lastActiveOrganizationId = JsonNullable.of((Object)lastActiveOrganizationId);
        return this;
    }

    public Session withLastActiveOrganizationId(JsonNullable<String> lastActiveOrganizationId) {
        Utils.checkNotNull(lastActiveOrganizationId, "lastActiveOrganizationId");
        this.lastActiveOrganizationId = lastActiveOrganizationId;
        return this;
    }

    public Session withLastActiveAt(long lastActiveAt) {
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        this.lastActiveAt = lastActiveAt;
        return this;
    }

    public Session withLatestActivity(SessionActivityResponse latestActivity) {
        Utils.checkNotNull(latestActivity, "latestActivity");
        this.latestActivity = JsonNullable.of((Object)latestActivity);
        return this;
    }

    public Session withLatestActivity(JsonNullable<? extends SessionActivityResponse> latestActivity) {
        Utils.checkNotNull(latestActivity, "latestActivity");
        this.latestActivity = latestActivity;
        return this;
    }

    public Session withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public Session withAbandonAt(long abandonAt) {
        Utils.checkNotNull(abandonAt, "abandonAt");
        this.abandonAt = abandonAt;
        return this;
    }

    public Session withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public Session withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session other = (Session)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.clientId, other.clientId) && Objects.deepEquals(this.actor, other.actor) && Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.lastActiveOrganizationId, other.lastActiveOrganizationId) && Objects.deepEquals(this.lastActiveAt, other.lastActiveAt) && Objects.deepEquals(this.latestActivity, other.latestActivity) && Objects.deepEquals(this.expireAt, other.expireAt) && Objects.deepEquals(this.abandonAt, other.abandonAt) && Objects.deepEquals(this.updatedAt, other.updatedAt) && Objects.deepEquals(this.createdAt, other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.userId, this.clientId, this.actor, this.status, this.lastActiveOrganizationId, this.lastActiveAt, this.latestActivity, this.expireAt, this.abandonAt, this.updatedAt, this.createdAt});
    }

    public String toString() {
        return Utils.toString(Session.class, new Object[]{"object", this.object, "id", this.id, "userId", this.userId, "clientId", this.clientId, "actor", this.actor, "status", this.status, "lastActiveOrganizationId", this.lastActiveOrganizationId, "lastActiveAt", this.lastActiveAt, "latestActivity", this.latestActivity, "expireAt", this.expireAt, "abandonAt", this.abandonAt, "updatedAt", this.updatedAt, "createdAt", this.createdAt});
    }

    public static final class Builder {
        private SessionObject object;
        private String id;
        private String userId;
        private String clientId;
        private JsonNullable<? extends Actor> actor = JsonNullable.undefined();
        private Status status;
        private JsonNullable<String> lastActiveOrganizationId = JsonNullable.undefined();
        private Long lastActiveAt;
        private JsonNullable<? extends SessionActivityResponse> latestActivity = JsonNullable.undefined();
        private Long expireAt;
        private Long abandonAt;
        private Long updatedAt;
        private Long createdAt;

        private Builder() {
        }

        public Builder object(SessionObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder actor(Actor actor) {
            Utils.checkNotNull(actor, "actor");
            this.actor = JsonNullable.of((Object)actor);
            return this;
        }

        public Builder actor(JsonNullable<? extends Actor> actor) {
            Utils.checkNotNull(actor, "actor");
            this.actor = actor;
            return this;
        }

        public Builder status(Status status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder lastActiveOrganizationId(String lastActiveOrganizationId) {
            Utils.checkNotNull(lastActiveOrganizationId, "lastActiveOrganizationId");
            this.lastActiveOrganizationId = JsonNullable.of((Object)lastActiveOrganizationId);
            return this;
        }

        public Builder lastActiveOrganizationId(JsonNullable<String> lastActiveOrganizationId) {
            Utils.checkNotNull(lastActiveOrganizationId, "lastActiveOrganizationId");
            this.lastActiveOrganizationId = lastActiveOrganizationId;
            return this;
        }

        public Builder lastActiveAt(long lastActiveAt) {
            Utils.checkNotNull(lastActiveAt, "lastActiveAt");
            this.lastActiveAt = lastActiveAt;
            return this;
        }

        public Builder latestActivity(SessionActivityResponse latestActivity) {
            Utils.checkNotNull(latestActivity, "latestActivity");
            this.latestActivity = JsonNullable.of((Object)latestActivity);
            return this;
        }

        public Builder latestActivity(JsonNullable<? extends SessionActivityResponse> latestActivity) {
            Utils.checkNotNull(latestActivity, "latestActivity");
            this.latestActivity = latestActivity;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder abandonAt(long abandonAt) {
            Utils.checkNotNull(abandonAt, "abandonAt");
            this.abandonAt = abandonAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Session build() {
            return new Session(this.object, this.id, this.userId, this.clientId, this.actor, this.status, this.lastActiveOrganizationId, this.lastActiveAt, this.latestActivity, this.expireAt, this.abandonAt, this.updatedAt, this.createdAt);
        }
    }
}

