/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.SignInTokenObject;
import com.clerk.backend_api.models.components.SignInTokenStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class SignInToken {
    @JsonProperty(value="object")
    private SignInTokenObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="status")
    private SignInTokenStatus status;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="token")
    private Optional<String> token;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<String> url;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public SignInToken(@JsonProperty(value="object") SignInTokenObject object, @JsonProperty(value="id") String id, @JsonProperty(value="status") SignInTokenStatus status, @JsonProperty(value="user_id") String userId, @JsonProperty(value="token") Optional<String> token, @JsonProperty(value="url") JsonNullable<String> url, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.status = status;
        this.userId = userId;
        this.token = token;
        this.url = url;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SignInToken(SignInTokenObject object, String id, SignInTokenStatus status, String userId, long createdAt, long updatedAt) {
        this(object, id, status, userId, Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), createdAt, updatedAt);
    }

    @JsonIgnore
    public SignInTokenObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public SignInTokenStatus status() {
        return this.status;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<String> token() {
        return this.token;
    }

    @JsonIgnore
    public JsonNullable<String> url() {
        return this.url;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public SignInToken withObject(SignInTokenObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public SignInToken withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public SignInToken withStatus(SignInTokenStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public SignInToken withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public SignInToken withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = Optional.ofNullable(token);
        return this;
    }

    public SignInToken withToken(Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public SignInToken withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public SignInToken withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public SignInToken withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public SignInToken withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignInToken other = (SignInToken)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.token, other.token) && Objects.deepEquals(this.url, other.url) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.status, this.userId, this.token, this.url, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(SignInToken.class, new Object[]{"object", this.object, "id", this.id, "status", this.status, "userId", this.userId, "token", this.token, "url", this.url, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private SignInTokenObject object;
        private String id;
        private SignInTokenStatus status;
        private String userId;
        private Optional<String> token = Optional.empty();
        private JsonNullable<String> url = JsonNullable.undefined();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(SignInTokenObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder status(SignInTokenStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = Optional.ofNullable(token);
            return this;
        }

        public Builder token(Optional<String> token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public SignInToken build() {
            return new SignInToken(this.object, this.id, this.status, this.userId, this.token, this.url, this.createdAt, this.updatedAt);
        }
    }
}

