/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class Strategy {
    public static final Strategy PHONE_CODE = new Strategy("phone_code");
    public static final Strategy EMAIL_CODE = new Strategy("email_code");
    public static final Strategy RESET_PASSWORD_EMAIL_CODE = new Strategy("reset_password_email_code");
    private static final Map<String, Strategy> values = Strategy.createValuesMap();
    private static final Map<String, StrategyEnum> enums = Strategy.createEnumsMap();
    private final String value;

    private Strategy(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Strategy of(String value) {
        Class<Strategy> clazz = Strategy.class;
        synchronized (Strategy.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new Strategy((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<StrategyEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Strategy other = (Strategy)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "Strategy [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Strategy[] values() {
        Class<Strategy> clazz = Strategy.class;
        synchronized (Strategy.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new Strategy[0]);
        }
    }

    private static final Map<String, Strategy> createValuesMap() {
        LinkedHashMap<String, Strategy> map = new LinkedHashMap<String, Strategy>();
        map.put("phone_code", PHONE_CODE);
        map.put("email_code", EMAIL_CODE);
        map.put("reset_password_email_code", RESET_PASSWORD_EMAIL_CODE);
        return map;
    }

    private static final Map<String, StrategyEnum> createEnumsMap() {
        HashMap<String, StrategyEnum> map = new HashMap<String, StrategyEnum>();
        map.put("phone_code", StrategyEnum.PHONE_CODE);
        map.put("email_code", StrategyEnum.EMAIL_CODE);
        map.put("reset_password_email_code", StrategyEnum.RESET_PASSWORD_EMAIL_CODE);
        return map;
    }

    public static enum StrategyEnum {
        PHONE_CODE("phone_code"),
        EMAIL_CODE("email_code"),
        RESET_PASSWORD_EMAIL_CODE("reset_password_email_code");

        private final String value;

        private StrategyEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<Strategy> {
        protected _Deserializer() {
            super(Strategy.class);
        }

        public Strategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return Strategy.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<Strategy> {
        protected _Serializer() {
            super(Strategy.class);
        }

        public void serialize(Strategy value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

