/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class VerificationStrategy {
    public static final VerificationStrategy ADMIN = new VerificationStrategy("admin");
    private static final Map<String, VerificationStrategy> values = VerificationStrategy.createValuesMap();
    private static final Map<String, VerificationStrategyEnum> enums = VerificationStrategy.createEnumsMap();
    private final String value;

    private VerificationStrategy(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerificationStrategy of(String value) {
        Class<VerificationStrategy> clazz = VerificationStrategy.class;
        synchronized (VerificationStrategy.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new VerificationStrategy((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<VerificationStrategyEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerificationStrategy other = (VerificationStrategy)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "VerificationStrategy [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerificationStrategy[] values() {
        Class<VerificationStrategy> clazz = VerificationStrategy.class;
        synchronized (VerificationStrategy.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new VerificationStrategy[0]);
        }
    }

    private static final Map<String, VerificationStrategy> createValuesMap() {
        LinkedHashMap<String, VerificationStrategy> map = new LinkedHashMap<String, VerificationStrategy>();
        map.put("admin", ADMIN);
        return map;
    }

    private static final Map<String, VerificationStrategyEnum> createEnumsMap() {
        HashMap<String, VerificationStrategyEnum> map = new HashMap<String, VerificationStrategyEnum>();
        map.put("admin", VerificationStrategyEnum.ADMIN);
        return map;
    }

    public static enum VerificationStrategyEnum {
        ADMIN("admin");

        private final String value;

        private VerificationStrategyEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<VerificationStrategy> {
        protected _Deserializer() {
            super(VerificationStrategy.class);
        }

        public VerificationStrategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return VerificationStrategy.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<VerificationStrategy> {
        protected _Serializer() {
            super(VerificationStrategy.class);
        }

        public void serialize(VerificationStrategy value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

