/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Web3WalletObject;
import com.clerk.backend_api.models.components.Web3WalletVerification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class Web3Wallet {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonProperty(value="object")
    private Web3WalletObject object;
    @JsonProperty(value="web3_wallet")
    private String web3Wallet;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification")
    private Optional<? extends Web3WalletVerification> verification;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public Web3Wallet(@JsonProperty(value="id") Optional<String> id, @JsonProperty(value="object") Web3WalletObject object, @JsonProperty(value="web3_wallet") String web3Wallet, @JsonProperty(value="verification") Optional<? extends Web3WalletVerification> verification, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        Utils.checkNotNull(verification, "verification");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.object = object;
        this.web3Wallet = web3Wallet;
        this.verification = verification;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public Web3Wallet(Web3WalletObject object, String web3Wallet, long createdAt, long updatedAt) {
        this(Optional.empty(), object, web3Wallet, Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public Web3WalletObject object() {
        return this.object;
    }

    @JsonIgnore
    public String web3Wallet() {
        return this.web3Wallet;
    }

    @JsonIgnore
    public Optional<Web3WalletVerification> verification() {
        return this.verification;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Web3Wallet withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public Web3Wallet withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Web3Wallet withObject(Web3WalletObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Web3Wallet withWeb3Wallet(String web3Wallet) {
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        this.web3Wallet = web3Wallet;
        return this;
    }

    public Web3Wallet withVerification(Web3WalletVerification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = Optional.ofNullable(verification);
        return this;
    }

    public Web3Wallet withVerification(Optional<? extends Web3WalletVerification> verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    public Web3Wallet withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public Web3Wallet withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Web3Wallet other = (Web3Wallet)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.web3Wallet, other.web3Wallet) && Objects.deepEquals(this.verification, other.verification) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.object, this.web3Wallet, this.verification, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(Web3Wallet.class, new Object[]{"id", this.id, "object", this.object, "web3Wallet", this.web3Wallet, "verification", this.verification, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Web3WalletObject object;
        private String web3Wallet;
        private Optional<? extends Web3WalletVerification> verification = Optional.empty();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(Web3WalletObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder web3Wallet(String web3Wallet) {
            Utils.checkNotNull(web3Wallet, "web3Wallet");
            this.web3Wallet = web3Wallet;
            return this;
        }

        public Builder verification(Web3WalletVerification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = Optional.ofNullable(verification);
            return this;
        }

        public Builder verification(Optional<? extends Web3WalletVerification> verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Web3Wallet build() {
            return new Web3Wallet(this.id, this.object, this.web3Wallet, this.verification, this.createdAt, this.updatedAt);
        }
    }
}

