/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.Actor;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class CreateActorTokenRequestBody {
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="actor")
    private Actor actor;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expires_in_seconds")
    private Optional<Long> expiresInSeconds;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="session_max_duration_in_seconds")
    private Optional<Long> sessionMaxDurationInSeconds;

    @JsonCreator
    public CreateActorTokenRequestBody(@JsonProperty(value="user_id") String userId, @JsonProperty(value="actor") Actor actor, @JsonProperty(value="expires_in_seconds") Optional<Long> expiresInSeconds, @JsonProperty(value="session_max_duration_in_seconds") Optional<Long> sessionMaxDurationInSeconds) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(actor, "actor");
        Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
        Utils.checkNotNull(sessionMaxDurationInSeconds, "sessionMaxDurationInSeconds");
        this.userId = userId;
        this.actor = actor;
        this.expiresInSeconds = expiresInSeconds;
        this.sessionMaxDurationInSeconds = sessionMaxDurationInSeconds;
    }

    public CreateActorTokenRequestBody(String userId, Actor actor) {
        this(userId, actor, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public Actor actor() {
        return this.actor;
    }

    @JsonIgnore
    public Optional<Long> expiresInSeconds() {
        return this.expiresInSeconds;
    }

    @JsonIgnore
    public Optional<Long> sessionMaxDurationInSeconds() {
        return this.sessionMaxDurationInSeconds;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateActorTokenRequestBody withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public CreateActorTokenRequestBody withActor(Actor actor) {
        Utils.checkNotNull(actor, "actor");
        this.actor = actor;
        return this;
    }

    public CreateActorTokenRequestBody withExpiresInSeconds(long expiresInSeconds) {
        Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
        this.expiresInSeconds = Optional.ofNullable(expiresInSeconds);
        return this;
    }

    public CreateActorTokenRequestBody withExpiresInSeconds(Optional<Long> expiresInSeconds) {
        Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
        this.expiresInSeconds = expiresInSeconds;
        return this;
    }

    public CreateActorTokenRequestBody withSessionMaxDurationInSeconds(long sessionMaxDurationInSeconds) {
        Utils.checkNotNull(sessionMaxDurationInSeconds, "sessionMaxDurationInSeconds");
        this.sessionMaxDurationInSeconds = Optional.ofNullable(sessionMaxDurationInSeconds);
        return this;
    }

    public CreateActorTokenRequestBody withSessionMaxDurationInSeconds(Optional<Long> sessionMaxDurationInSeconds) {
        Utils.checkNotNull(sessionMaxDurationInSeconds, "sessionMaxDurationInSeconds");
        this.sessionMaxDurationInSeconds = sessionMaxDurationInSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateActorTokenRequestBody other = (CreateActorTokenRequestBody)o;
        return Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.actor, other.actor) && Objects.deepEquals(this.expiresInSeconds, other.expiresInSeconds) && Objects.deepEquals(this.sessionMaxDurationInSeconds, other.sessionMaxDurationInSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.actor, this.expiresInSeconds, this.sessionMaxDurationInSeconds);
    }

    public String toString() {
        return Utils.toString(CreateActorTokenRequestBody.class, "userId", this.userId, "actor", this.actor, "expiresInSeconds", this.expiresInSeconds, "sessionMaxDurationInSeconds", this.sessionMaxDurationInSeconds);
    }

    public static final class Builder {
        private String userId;
        private Actor actor;
        private Optional<Long> expiresInSeconds;
        private Optional<Long> sessionMaxDurationInSeconds;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_ExpiresInSeconds = new LazySingletonValue<Optional<Long>>("expires_in_seconds", "3600", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_SessionMaxDurationInSeconds = new LazySingletonValue<Optional<Long>>("session_max_duration_in_seconds", "1800", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder actor(Actor actor) {
            Utils.checkNotNull(actor, "actor");
            this.actor = actor;
            return this;
        }

        public Builder expiresInSeconds(long expiresInSeconds) {
            Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
            this.expiresInSeconds = Optional.ofNullable(expiresInSeconds);
            return this;
        }

        public Builder expiresInSeconds(Optional<Long> expiresInSeconds) {
            Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
            this.expiresInSeconds = expiresInSeconds;
            return this;
        }

        public Builder sessionMaxDurationInSeconds(long sessionMaxDurationInSeconds) {
            Utils.checkNotNull(sessionMaxDurationInSeconds, "sessionMaxDurationInSeconds");
            this.sessionMaxDurationInSeconds = Optional.ofNullable(sessionMaxDurationInSeconds);
            return this;
        }

        public Builder sessionMaxDurationInSeconds(Optional<Long> sessionMaxDurationInSeconds) {
            Utils.checkNotNull(sessionMaxDurationInSeconds, "sessionMaxDurationInSeconds");
            this.sessionMaxDurationInSeconds = sessionMaxDurationInSeconds;
            return this;
        }

        public CreateActorTokenRequestBody build() {
            if (this.expiresInSeconds == null) {
                this.expiresInSeconds = _SINGLETON_VALUE_ExpiresInSeconds.value();
            }
            if (this.sessionMaxDurationInSeconds == null) {
                this.sessionMaxDurationInSeconds = _SINGLETON_VALUE_SessionMaxDurationInSeconds.value();
            }
            return new CreateActorTokenRequestBody(this.userId, this.actor, this.expiresInSeconds, this.sessionMaxDurationInSeconds);
        }
    }
}

