/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.ActorToken;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class CreateActorTokenResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ActorToken> actorToken;

    @JsonCreator
    public CreateActorTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ActorToken> actorToken) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(actorToken, "actorToken");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.actorToken = actorToken;
    }

    public CreateActorTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ActorToken> actorToken() {
        return this.actorToken;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateActorTokenResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateActorTokenResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateActorTokenResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateActorTokenResponse withActorToken(ActorToken actorToken) {
        Utils.checkNotNull(actorToken, "actorToken");
        this.actorToken = Optional.ofNullable(actorToken);
        return this;
    }

    public CreateActorTokenResponse withActorToken(Optional<? extends ActorToken> actorToken) {
        Utils.checkNotNull(actorToken, "actorToken");
        this.actorToken = actorToken;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateActorTokenResponse other = (CreateActorTokenResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.actorToken, other.actorToken);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.actorToken);
    }

    public String toString() {
        return Utils.toString(CreateActorTokenResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "actorToken", this.actorToken);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ActorToken> actorToken = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder actorToken(ActorToken actorToken) {
            Utils.checkNotNull(actorToken, "actorToken");
            this.actorToken = Optional.ofNullable(actorToken);
            return this;
        }

        public Builder actorToken(Optional<? extends ActorToken> actorToken) {
            Utils.checkNotNull(actorToken, "actorToken");
            this.actorToken = actorToken;
            return this;
        }

        public CreateActorTokenResponse build() {
            return new CreateActorTokenResponse(this.contentType, this.statusCode, this.rawResponse, this.actorToken);
        }
    }
}

