/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.TestingToken;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class CreateTestingTokenResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TestingToken> testingToken;

    @JsonCreator
    public CreateTestingTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TestingToken> testingToken) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(testingToken, "testingToken");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.testingToken = testingToken;
    }

    public CreateTestingTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TestingToken> testingToken() {
        return this.testingToken;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateTestingTokenResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateTestingTokenResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateTestingTokenResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateTestingTokenResponse withTestingToken(TestingToken testingToken) {
        Utils.checkNotNull(testingToken, "testingToken");
        this.testingToken = Optional.ofNullable(testingToken);
        return this;
    }

    public CreateTestingTokenResponse withTestingToken(Optional<? extends TestingToken> testingToken) {
        Utils.checkNotNull(testingToken, "testingToken");
        this.testingToken = testingToken;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTestingTokenResponse other = (CreateTestingTokenResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.testingToken, other.testingToken);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.testingToken);
    }

    public String toString() {
        return Utils.toString(CreateTestingTokenResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "testingToken", this.testingToken);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TestingToken> testingToken = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder testingToken(TestingToken testingToken) {
            Utils.checkNotNull(testingToken, "testingToken");
            this.testingToken = Optional.ofNullable(testingToken);
            return this;
        }

        public Builder testingToken(Optional<? extends TestingToken> testingToken) {
            Utils.checkNotNull(testingToken, "testingToken");
            this.testingToken = testingToken;
            return this;
        }

        public CreateTestingTokenResponse build() {
            return new CreateTestingTokenResponse(this.contentType, this.statusCode, this.rawResponse, this.testingToken);
        }
    }
}

