/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.DeleteExternalAccountResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteExternalAccountRequestBuilder {
    private String userId;
    private String externalAccountId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallDeleteExternalAccount sdk;

    public DeleteExternalAccountRequestBuilder(SDKMethodInterfaces.MethodCallDeleteExternalAccount sdk) {
        this.sdk = sdk;
    }

    public DeleteExternalAccountRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public DeleteExternalAccountRequestBuilder externalAccountId(String externalAccountId) {
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        this.externalAccountId = externalAccountId;
        return this;
    }

    public DeleteExternalAccountRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteExternalAccountRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public DeleteExternalAccountResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.deleteExternalAccount(this.userId, this.externalAccountId, options);
    }
}

