/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class DeleteOrganizationMembershipRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;

    @JsonCreator
    public DeleteOrganizationMembershipRequest(String organizationId, String userId) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(userId, "userId");
        this.organizationId = organizationId;
        this.userId = userId;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public DeleteOrganizationMembershipRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public DeleteOrganizationMembershipRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOrganizationMembershipRequest other = (DeleteOrganizationMembershipRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.userId, other.userId);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.userId);
    }

    public String toString() {
        return Utils.toString(DeleteOrganizationMembershipRequest.class, "organizationId", this.organizationId, "userId", this.userId);
    }

    public static final class Builder {
        private String organizationId;
        private String userId;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public DeleteOrganizationMembershipRequest build() {
            return new DeleteOrganizationMembershipRequest(this.organizationId, this.userId);
        }
    }
}

