/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationMembership;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class DeleteOrganizationMembershipResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationMembership> organizationMembership;

    @JsonCreator
    public DeleteOrganizationMembershipResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationMembership> organizationMembership) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationMembership, "organizationMembership");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationMembership = organizationMembership;
    }

    public DeleteOrganizationMembershipResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationMembership> organizationMembership() {
        return this.organizationMembership;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public DeleteOrganizationMembershipResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public DeleteOrganizationMembershipResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public DeleteOrganizationMembershipResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public DeleteOrganizationMembershipResponse withOrganizationMembership(OrganizationMembership organizationMembership) {
        Utils.checkNotNull(organizationMembership, "organizationMembership");
        this.organizationMembership = Optional.ofNullable(organizationMembership);
        return this;
    }

    public DeleteOrganizationMembershipResponse withOrganizationMembership(Optional<? extends OrganizationMembership> organizationMembership) {
        Utils.checkNotNull(organizationMembership, "organizationMembership");
        this.organizationMembership = organizationMembership;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOrganizationMembershipResponse other = (DeleteOrganizationMembershipResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.organizationMembership, other.organizationMembership);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.organizationMembership);
    }

    public String toString() {
        return Utils.toString(DeleteOrganizationMembershipResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationMembership", this.organizationMembership);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationMembership> organizationMembership = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationMembership(OrganizationMembership organizationMembership) {
            Utils.checkNotNull(organizationMembership, "organizationMembership");
            this.organizationMembership = Optional.ofNullable(organizationMembership);
            return this;
        }

        public Builder organizationMembership(Optional<? extends OrganizationMembership> organizationMembership) {
            Utils.checkNotNull(organizationMembership, "organizationMembership");
            this.organizationMembership = organizationMembership;
            return this;
        }

        public DeleteOrganizationMembershipResponse build() {
            return new DeleteOrganizationMembershipResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationMembership);
        }
    }
}

