/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class GetEmailAddressRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=email_address_id")
    private String emailAddressId;

    @JsonCreator
    public GetEmailAddressRequest(String emailAddressId) {
        Utils.checkNotNull(emailAddressId, "emailAddressId");
        this.emailAddressId = emailAddressId;
    }

    @JsonIgnore
    public String emailAddressId() {
        return this.emailAddressId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetEmailAddressRequest withEmailAddressId(String emailAddressId) {
        Utils.checkNotNull(emailAddressId, "emailAddressId");
        this.emailAddressId = emailAddressId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetEmailAddressRequest other = (GetEmailAddressRequest)o;
        return Objects.deepEquals(this.emailAddressId, other.emailAddressId);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddressId);
    }

    public String toString() {
        return Utils.toString(GetEmailAddressRequest.class, "emailAddressId", this.emailAddressId);
    }

    public static final class Builder {
        private String emailAddressId;

        private Builder() {
        }

        public Builder emailAddressId(String emailAddressId) {
            Utils.checkNotNull(emailAddressId, "emailAddressId");
            this.emailAddressId = emailAddressId;
            return this;
        }

        public GetEmailAddressRequest build() {
            return new GetEmailAddressRequest(this.emailAddressId);
        }
    }
}

