/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.ResponseBody;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GetOAuthAccessTokenResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<ResponseBody>> responseBodies;

    @JsonCreator
    public GetOAuthAccessTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<ResponseBody>> responseBodies) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(responseBodies, "responseBodies");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.responseBodies = responseBodies;
    }

    public GetOAuthAccessTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<ResponseBody>> responseBodies() {
        return this.responseBodies;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetOAuthAccessTokenResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetOAuthAccessTokenResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetOAuthAccessTokenResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetOAuthAccessTokenResponse withResponseBodies(List<ResponseBody> responseBodies) {
        Utils.checkNotNull(responseBodies, "responseBodies");
        this.responseBodies = Optional.ofNullable(responseBodies);
        return this;
    }

    public GetOAuthAccessTokenResponse withResponseBodies(Optional<? extends List<ResponseBody>> responseBodies) {
        Utils.checkNotNull(responseBodies, "responseBodies");
        this.responseBodies = responseBodies;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOAuthAccessTokenResponse other = (GetOAuthAccessTokenResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.responseBodies, other.responseBodies);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.responseBodies);
    }

    public String toString() {
        return Utils.toString(GetOAuthAccessTokenResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "responseBodies", this.responseBodies);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<ResponseBody>> responseBodies = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder responseBodies(List<ResponseBody> responseBodies) {
            Utils.checkNotNull(responseBodies, "responseBodies");
            this.responseBodies = Optional.ofNullable(responseBodies);
            return this;
        }

        public Builder responseBodies(Optional<? extends List<ResponseBody>> responseBodies) {
            Utils.checkNotNull(responseBodies, "responseBodies");
            this.responseBodies = responseBodies;
            return this;
        }

        public GetOAuthAccessTokenResponse build() {
            return new GetOAuthAccessTokenResponse(this.contentType, this.statusCode, this.rawResponse, this.responseBodies);
        }
    }
}

