/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.TemplateType;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class GetTemplateListRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_type")
    private TemplateType templateType;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=paginated")
    private Optional<Boolean> paginated;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public GetTemplateListRequest(TemplateType templateType, Optional<Boolean> paginated, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(templateType, "templateType");
        Utils.checkNotNull(paginated, "paginated");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.templateType = templateType;
        this.paginated = paginated;
        this.limit = limit;
        this.offset = offset;
    }

    public GetTemplateListRequest(TemplateType templateType) {
        this(templateType, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public TemplateType templateType() {
        return this.templateType;
    }

    @JsonIgnore
    public Optional<Boolean> paginated() {
        return this.paginated;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetTemplateListRequest withTemplateType(TemplateType templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public GetTemplateListRequest withPaginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.ofNullable(paginated);
        return this;
    }

    public GetTemplateListRequest withPaginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public GetTemplateListRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public GetTemplateListRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetTemplateListRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public GetTemplateListRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTemplateListRequest other = (GetTemplateListRequest)o;
        return Objects.deepEquals((Object)this.templateType, (Object)other.templateType) && Objects.deepEquals(this.paginated, other.paginated) && Objects.deepEquals(this.limit, other.limit) && Objects.deepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.templateType, this.paginated, this.limit, this.offset});
    }

    public String toString() {
        return Utils.toString(GetTemplateListRequest.class, new Object[]{"templateType", this.templateType, "paginated", this.paginated, "limit", this.limit, "offset", this.offset});
    }

    public static final class Builder {
        private TemplateType templateType;
        private Optional<Boolean> paginated = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder templateType(TemplateType templateType) {
            Utils.checkNotNull(templateType, "templateType");
            this.templateType = templateType;
            return this;
        }

        public Builder paginated(boolean paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = Optional.ofNullable(paginated);
            return this;
        }

        public Builder paginated(Optional<Boolean> paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = paginated;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public GetTemplateListRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new GetTemplateListRequest(this.templateType, this.paginated, this.limit, this.offset);
        }
    }
}

