/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationMemberships;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class InstanceGetOrganizationMembershipsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationMemberships> organizationMemberships;

    @JsonCreator
    public InstanceGetOrganizationMembershipsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationMemberships> organizationMemberships) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationMemberships, "organizationMemberships");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationMemberships = organizationMemberships;
    }

    public InstanceGetOrganizationMembershipsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationMemberships> organizationMemberships() {
        return this.organizationMemberships;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public InstanceGetOrganizationMembershipsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public InstanceGetOrganizationMembershipsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public InstanceGetOrganizationMembershipsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public InstanceGetOrganizationMembershipsResponse withOrganizationMemberships(OrganizationMemberships organizationMemberships) {
        Utils.checkNotNull(organizationMemberships, "organizationMemberships");
        this.organizationMemberships = Optional.ofNullable(organizationMemberships);
        return this;
    }

    public InstanceGetOrganizationMembershipsResponse withOrganizationMemberships(Optional<? extends OrganizationMemberships> organizationMemberships) {
        Utils.checkNotNull(organizationMemberships, "organizationMemberships");
        this.organizationMemberships = organizationMemberships;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceGetOrganizationMembershipsResponse other = (InstanceGetOrganizationMembershipsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.organizationMemberships, other.organizationMemberships);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.organizationMemberships);
    }

    public String toString() {
        return Utils.toString(InstanceGetOrganizationMembershipsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationMemberships", this.organizationMemberships);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationMemberships> organizationMemberships = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationMemberships(OrganizationMemberships organizationMemberships) {
            Utils.checkNotNull(organizationMemberships, "organizationMemberships");
            this.organizationMemberships = Optional.ofNullable(organizationMemberships);
            return this;
        }

        public Builder organizationMemberships(Optional<? extends OrganizationMemberships> organizationMemberships) {
            Utils.checkNotNull(organizationMemberships, "organizationMemberships");
            this.organizationMemberships = organizationMemberships;
            return this;
        }

        public InstanceGetOrganizationMembershipsResponse build() {
            return new InstanceGetOrganizationMembershipsResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationMemberships);
        }
    }
}

