/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.ListOAuthApplicationsResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class ListOAuthApplicationsRequestBuilder {
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<Long> offset = Utils.readDefaultOrConstValue("offset", "0", new TypeReference<Optional<Long>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallListOAuthApplications sdk;
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

    public ListOAuthApplicationsRequestBuilder(SDKMethodInterfaces.MethodCallListOAuthApplications sdk) {
        this.sdk = sdk;
    }

    public ListOAuthApplicationsRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListOAuthApplicationsRequestBuilder offset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.of(offset);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder offset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public ListOAuthApplicationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ListOAuthApplicationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public ListOAuthApplicationsResponse call() throws Exception {
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        if (this.offset == null) {
            this.offset = _SINGLETON_VALUE_Offset.value();
        }
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.list(this.limit, this.offset, options);
    }
}

