/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationInvitations;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class ListPendingOrganizationInvitationsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationInvitations> organizationInvitations;

    @JsonCreator
    public ListPendingOrganizationInvitationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationInvitations> organizationInvitations) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationInvitations, "organizationInvitations");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationInvitations = organizationInvitations;
    }

    public ListPendingOrganizationInvitationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationInvitations> organizationInvitations() {
        return this.organizationInvitations;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ListPendingOrganizationInvitationsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListPendingOrganizationInvitationsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListPendingOrganizationInvitationsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListPendingOrganizationInvitationsResponse withOrganizationInvitations(OrganizationInvitations organizationInvitations) {
        Utils.checkNotNull(organizationInvitations, "organizationInvitations");
        this.organizationInvitations = Optional.ofNullable(organizationInvitations);
        return this;
    }

    public ListPendingOrganizationInvitationsResponse withOrganizationInvitations(Optional<? extends OrganizationInvitations> organizationInvitations) {
        Utils.checkNotNull(organizationInvitations, "organizationInvitations");
        this.organizationInvitations = organizationInvitations;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListPendingOrganizationInvitationsResponse other = (ListPendingOrganizationInvitationsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.organizationInvitations, other.organizationInvitations);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.organizationInvitations);
    }

    public String toString() {
        return Utils.toString(ListPendingOrganizationInvitationsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationInvitations", this.organizationInvitations);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationInvitations> organizationInvitations = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationInvitations(OrganizationInvitations organizationInvitations) {
            Utils.checkNotNull(organizationInvitations, "organizationInvitations");
            this.organizationInvitations = Optional.ofNullable(organizationInvitations);
            return this;
        }

        public Builder organizationInvitations(Optional<? extends OrganizationInvitations> organizationInvitations) {
            Utils.checkNotNull(organizationInvitations, "organizationInvitations");
            this.organizationInvitations = organizationInvitations;
            return this;
        }

        public ListPendingOrganizationInvitationsResponse build() {
            return new ListPendingOrganizationInvitationsResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationInvitations);
        }
    }
}

