/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class PreviewTemplateRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="subject")
    private JsonNullable<String> subject;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="body")
    private Optional<String> body;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="from_email_name")
    private Optional<String> fromEmailName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="reply_to_email_name")
    private Optional<String> replyToEmailName;

    @JsonCreator
    public PreviewTemplateRequestBody(@JsonProperty(value="subject") JsonNullable<String> subject, @JsonProperty(value="body") Optional<String> body, @JsonProperty(value="from_email_name") Optional<String> fromEmailName, @JsonProperty(value="reply_to_email_name") Optional<String> replyToEmailName) {
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(fromEmailName, "fromEmailName");
        Utils.checkNotNull(replyToEmailName, "replyToEmailName");
        this.subject = subject;
        this.body = body;
        this.fromEmailName = fromEmailName;
        this.replyToEmailName = replyToEmailName;
    }

    public PreviewTemplateRequestBody() {
        this((JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public JsonNullable<String> subject() {
        return this.subject;
    }

    @JsonIgnore
    public Optional<String> body() {
        return this.body;
    }

    @JsonIgnore
    public Optional<String> fromEmailName() {
        return this.fromEmailName;
    }

    @JsonIgnore
    public Optional<String> replyToEmailName() {
        return this.replyToEmailName;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public PreviewTemplateRequestBody withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = JsonNullable.of((Object)subject);
        return this;
    }

    public PreviewTemplateRequestBody withSubject(JsonNullable<String> subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    public PreviewTemplateRequestBody withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = Optional.ofNullable(body);
        return this;
    }

    public PreviewTemplateRequestBody withBody(Optional<String> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public PreviewTemplateRequestBody withFromEmailName(String fromEmailName) {
        Utils.checkNotNull(fromEmailName, "fromEmailName");
        this.fromEmailName = Optional.ofNullable(fromEmailName);
        return this;
    }

    public PreviewTemplateRequestBody withFromEmailName(Optional<String> fromEmailName) {
        Utils.checkNotNull(fromEmailName, "fromEmailName");
        this.fromEmailName = fromEmailName;
        return this;
    }

    public PreviewTemplateRequestBody withReplyToEmailName(String replyToEmailName) {
        Utils.checkNotNull(replyToEmailName, "replyToEmailName");
        this.replyToEmailName = Optional.ofNullable(replyToEmailName);
        return this;
    }

    public PreviewTemplateRequestBody withReplyToEmailName(Optional<String> replyToEmailName) {
        Utils.checkNotNull(replyToEmailName, "replyToEmailName");
        this.replyToEmailName = replyToEmailName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreviewTemplateRequestBody other = (PreviewTemplateRequestBody)o;
        return Objects.deepEquals(this.subject, other.subject) && Objects.deepEquals(this.body, other.body) && Objects.deepEquals(this.fromEmailName, other.fromEmailName) && Objects.deepEquals(this.replyToEmailName, other.replyToEmailName);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.body, this.fromEmailName, this.replyToEmailName);
    }

    public String toString() {
        return Utils.toString(PreviewTemplateRequestBody.class, "subject", this.subject, "body", this.body, "fromEmailName", this.fromEmailName, "replyToEmailName", this.replyToEmailName);
    }

    public static final class Builder {
        private JsonNullable<String> subject = JsonNullable.undefined();
        private Optional<String> body = Optional.empty();
        private Optional<String> fromEmailName = Optional.empty();
        private Optional<String> replyToEmailName = Optional.empty();

        private Builder() {
        }

        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = JsonNullable.of((Object)subject);
            return this;
        }

        public Builder subject(JsonNullable<String> subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }

        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = Optional.ofNullable(body);
            return this;
        }

        public Builder body(Optional<String> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public Builder fromEmailName(String fromEmailName) {
            Utils.checkNotNull(fromEmailName, "fromEmailName");
            this.fromEmailName = Optional.ofNullable(fromEmailName);
            return this;
        }

        public Builder fromEmailName(Optional<String> fromEmailName) {
            Utils.checkNotNull(fromEmailName, "fromEmailName");
            this.fromEmailName = fromEmailName;
            return this;
        }

        public Builder replyToEmailName(String replyToEmailName) {
            Utils.checkNotNull(replyToEmailName, "replyToEmailName");
            this.replyToEmailName = Optional.ofNullable(replyToEmailName);
            return this;
        }

        public Builder replyToEmailName(Optional<String> replyToEmailName) {
            Utils.checkNotNull(replyToEmailName, "replyToEmailName");
            this.replyToEmailName = replyToEmailName;
            return this;
        }

        public PreviewTemplateRequestBody build() {
            return new PreviewTemplateRequestBody(this.subject, this.body, this.fromEmailName, this.replyToEmailName);
        }
    }
}

