/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class ResponseBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<String> object;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="external_account_id")
    private Optional<String> externalAccountId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="provider_user_id")
    private Optional<String> providerUserId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="token")
    private Optional<String> token;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="provider")
    private Optional<String> provider;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="public_metadata")
    private Optional<? extends Map<String, Object>> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="label")
    private JsonNullable<String> label;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="scopes")
    private Optional<? extends List<String>> scopes;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="token_secret")
    private Optional<String> tokenSecret;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expires_at")
    private JsonNullable<Long> expiresAt;

    @JsonCreator
    public ResponseBody(@JsonProperty(value="object") Optional<String> object, @JsonProperty(value="external_account_id") Optional<String> externalAccountId, @JsonProperty(value="provider_user_id") Optional<String> providerUserId, @JsonProperty(value="token") Optional<String> token, @JsonProperty(value="provider") Optional<String> provider, @JsonProperty(value="public_metadata") Optional<? extends Map<String, Object>> publicMetadata, @JsonProperty(value="label") JsonNullable<String> label, @JsonProperty(value="scopes") Optional<? extends List<String>> scopes, @JsonProperty(value="token_secret") Optional<String> tokenSecret, @JsonProperty(value="expires_at") JsonNullable<Long> expiresAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        Utils.checkNotNull(providerUserId, "providerUserId");
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(tokenSecret, "tokenSecret");
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.object = object;
        this.externalAccountId = externalAccountId;
        this.providerUserId = providerUserId;
        this.token = token;
        this.provider = provider;
        this.publicMetadata = publicMetadata;
        this.label = label;
        this.scopes = scopes;
        this.tokenSecret = tokenSecret;
        this.expiresAt = expiresAt;
    }

    public ResponseBody() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Optional<String> object() {
        return this.object;
    }

    @JsonIgnore
    public Optional<String> externalAccountId() {
        return this.externalAccountId;
    }

    @JsonIgnore
    public Optional<String> providerUserId() {
        return this.providerUserId;
    }

    @JsonIgnore
    public Optional<String> token() {
        return this.token;
    }

    @JsonIgnore
    public Optional<String> provider() {
        return this.provider;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public JsonNullable<String> label() {
        return this.label;
    }

    @JsonIgnore
    public Optional<List<String>> scopes() {
        return this.scopes;
    }

    @JsonIgnore
    public Optional<String> tokenSecret() {
        return this.tokenSecret;
    }

    @JsonIgnore
    public JsonNullable<Long> expiresAt() {
        return this.expiresAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ResponseBody withObject(String object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public ResponseBody withObject(Optional<String> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public ResponseBody withExternalAccountId(String externalAccountId) {
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        this.externalAccountId = Optional.ofNullable(externalAccountId);
        return this;
    }

    public ResponseBody withExternalAccountId(Optional<String> externalAccountId) {
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        this.externalAccountId = externalAccountId;
        return this;
    }

    public ResponseBody withProviderUserId(String providerUserId) {
        Utils.checkNotNull(providerUserId, "providerUserId");
        this.providerUserId = Optional.ofNullable(providerUserId);
        return this;
    }

    public ResponseBody withProviderUserId(Optional<String> providerUserId) {
        Utils.checkNotNull(providerUserId, "providerUserId");
        this.providerUserId = providerUserId;
        return this;
    }

    public ResponseBody withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = Optional.ofNullable(token);
        return this;
    }

    public ResponseBody withToken(Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public ResponseBody withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = Optional.ofNullable(provider);
        return this;
    }

    public ResponseBody withProvider(Optional<String> provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public ResponseBody withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = Optional.ofNullable(publicMetadata);
        return this;
    }

    public ResponseBody withPublicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public ResponseBody withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of((Object)label);
        return this;
    }

    public ResponseBody withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    public ResponseBody withScopes(List<String> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = Optional.ofNullable(scopes);
        return this;
    }

    public ResponseBody withScopes(Optional<? extends List<String>> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public ResponseBody withTokenSecret(String tokenSecret) {
        Utils.checkNotNull(tokenSecret, "tokenSecret");
        this.tokenSecret = Optional.ofNullable(tokenSecret);
        return this;
    }

    public ResponseBody withTokenSecret(Optional<String> tokenSecret) {
        Utils.checkNotNull(tokenSecret, "tokenSecret");
        this.tokenSecret = tokenSecret;
        return this;
    }

    public ResponseBody withExpiresAt(long expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = JsonNullable.of((Object)expiresAt);
        return this;
    }

    public ResponseBody withExpiresAt(JsonNullable<Long> expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = expiresAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseBody other = (ResponseBody)o;
        return Objects.deepEquals(this.object, other.object) && Objects.deepEquals(this.externalAccountId, other.externalAccountId) && Objects.deepEquals(this.providerUserId, other.providerUserId) && Objects.deepEquals(this.token, other.token) && Objects.deepEquals(this.provider, other.provider) && Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.label, other.label) && Objects.deepEquals(this.scopes, other.scopes) && Objects.deepEquals(this.tokenSecret, other.tokenSecret) && Objects.deepEquals(this.expiresAt, other.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.externalAccountId, this.providerUserId, this.token, this.provider, this.publicMetadata, this.label, this.scopes, this.tokenSecret, this.expiresAt);
    }

    public String toString() {
        return Utils.toString(ResponseBody.class, "object", this.object, "externalAccountId", this.externalAccountId, "providerUserId", this.providerUserId, "token", this.token, "provider", this.provider, "publicMetadata", this.publicMetadata, "label", this.label, "scopes", this.scopes, "tokenSecret", this.tokenSecret, "expiresAt", this.expiresAt);
    }

    public static final class Builder {
        private Optional<String> object = Optional.empty();
        private Optional<String> externalAccountId = Optional.empty();
        private Optional<String> providerUserId = Optional.empty();
        private Optional<String> token = Optional.empty();
        private Optional<String> provider = Optional.empty();
        private Optional<? extends Map<String, Object>> publicMetadata = Optional.empty();
        private JsonNullable<String> label = JsonNullable.undefined();
        private Optional<? extends List<String>> scopes = Optional.empty();
        private Optional<String> tokenSecret = Optional.empty();
        private JsonNullable<Long> expiresAt = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(String object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<String> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder externalAccountId(String externalAccountId) {
            Utils.checkNotNull(externalAccountId, "externalAccountId");
            this.externalAccountId = Optional.ofNullable(externalAccountId);
            return this;
        }

        public Builder externalAccountId(Optional<String> externalAccountId) {
            Utils.checkNotNull(externalAccountId, "externalAccountId");
            this.externalAccountId = externalAccountId;
            return this;
        }

        public Builder providerUserId(String providerUserId) {
            Utils.checkNotNull(providerUserId, "providerUserId");
            this.providerUserId = Optional.ofNullable(providerUserId);
            return this;
        }

        public Builder providerUserId(Optional<String> providerUserId) {
            Utils.checkNotNull(providerUserId, "providerUserId");
            this.providerUserId = providerUserId;
            return this;
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = Optional.ofNullable(token);
            return this;
        }

        public Builder token(Optional<String> token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = Optional.ofNullable(provider);
            return this;
        }

        public Builder provider(Optional<String> provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = Optional.ofNullable(publicMetadata);
            return this;
        }

        public Builder publicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of((Object)label);
            return this;
        }

        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = Optional.ofNullable(scopes);
            return this;
        }

        public Builder scopes(Optional<? extends List<String>> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder tokenSecret(String tokenSecret) {
            Utils.checkNotNull(tokenSecret, "tokenSecret");
            this.tokenSecret = Optional.ofNullable(tokenSecret);
            return this;
        }

        public Builder tokenSecret(Optional<String> tokenSecret) {
            Utils.checkNotNull(tokenSecret, "tokenSecret");
            this.tokenSecret = tokenSecret;
            return this;
        }

        public Builder expiresAt(long expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = JsonNullable.of((Object)expiresAt);
            return this;
        }

        public Builder expiresAt(JsonNullable<Long> expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = expiresAt;
            return this;
        }

        public ResponseBody build() {
            return new ResponseBody(this.object, this.externalAccountId, this.providerUserId, this.token, this.provider, this.publicMetadata, this.label, this.scopes, this.tokenSecret, this.expiresAt);
        }
    }
}

