/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.RevertTemplatePathParamTemplateType;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class RevertTemplateRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_type")
    private RevertTemplatePathParamTemplateType templateType;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=slug")
    private String slug;

    @JsonCreator
    public RevertTemplateRequest(RevertTemplatePathParamTemplateType templateType, String slug) {
        Utils.checkNotNull(templateType, "templateType");
        Utils.checkNotNull(slug, "slug");
        this.templateType = templateType;
        this.slug = slug;
    }

    @JsonIgnore
    public RevertTemplatePathParamTemplateType templateType() {
        return this.templateType;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public RevertTemplateRequest withTemplateType(RevertTemplatePathParamTemplateType templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public RevertTemplateRequest withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevertTemplateRequest other = (RevertTemplateRequest)o;
        return Objects.deepEquals((Object)this.templateType, (Object)other.templateType) && Objects.deepEquals(this.slug, other.slug);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.templateType, this.slug});
    }

    public String toString() {
        return Utils.toString(RevertTemplateRequest.class, new Object[]{"templateType", this.templateType, "slug", this.slug});
    }

    public static final class Builder {
        private RevertTemplatePathParamTemplateType templateType;
        private String slug;

        private Builder() {
        }

        public Builder templateType(RevertTemplatePathParamTemplateType templateType) {
            Utils.checkNotNull(templateType, "templateType");
            this.templateType = templateType;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public RevertTemplateRequest build() {
            return new RevertTemplateRequest(this.templateType, this.slug);
        }
    }
}

