/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class RevokeInvitationRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=invitation_id")
    private String invitationId;

    @JsonCreator
    public RevokeInvitationRequest(String invitationId) {
        Utils.checkNotNull(invitationId, "invitationId");
        this.invitationId = invitationId;
    }

    @JsonIgnore
    public String invitationId() {
        return this.invitationId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public RevokeInvitationRequest withInvitationId(String invitationId) {
        Utils.checkNotNull(invitationId, "invitationId");
        this.invitationId = invitationId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevokeInvitationRequest other = (RevokeInvitationRequest)o;
        return Objects.deepEquals(this.invitationId, other.invitationId);
    }

    public int hashCode() {
        return Objects.hash(this.invitationId);
    }

    public String toString() {
        return Utils.toString(RevokeInvitationRequest.class, "invitationId", this.invitationId);
    }

    public static final class Builder {
        private String invitationId;

        private Builder() {
        }

        public Builder invitationId(String invitationId) {
            Utils.checkNotNull(invitationId, "invitationId");
            this.invitationId = invitationId;
            return this;
        }

        public RevokeInvitationRequest build() {
            return new RevokeInvitationRequest(this.invitationId);
        }
    }
}

