/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.RevokeOrganizationInvitationRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class RevokeOrganizationInvitationRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=invitation_id")
    private String invitationId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends RevokeOrganizationInvitationRequestBody> requestBody;

    @JsonCreator
    public RevokeOrganizationInvitationRequest(String organizationId, String invitationId, Optional<? extends RevokeOrganizationInvitationRequestBody> requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(invitationId, "invitationId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.invitationId = invitationId;
        this.requestBody = requestBody;
    }

    public RevokeOrganizationInvitationRequest(String organizationId, String invitationId) {
        this(organizationId, invitationId, Optional.empty());
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String invitationId() {
        return this.invitationId;
    }

    @JsonIgnore
    public Optional<RevokeOrganizationInvitationRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public RevokeOrganizationInvitationRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public RevokeOrganizationInvitationRequest withInvitationId(String invitationId) {
        Utils.checkNotNull(invitationId, "invitationId");
        this.invitationId = invitationId;
        return this;
    }

    public RevokeOrganizationInvitationRequest withRequestBody(RevokeOrganizationInvitationRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public RevokeOrganizationInvitationRequest withRequestBody(Optional<? extends RevokeOrganizationInvitationRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevokeOrganizationInvitationRequest other = (RevokeOrganizationInvitationRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.invitationId, other.invitationId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.invitationId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(RevokeOrganizationInvitationRequest.class, "organizationId", this.organizationId, "invitationId", this.invitationId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private String invitationId;
        private Optional<? extends RevokeOrganizationInvitationRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder invitationId(String invitationId) {
            Utils.checkNotNull(invitationId, "invitationId");
            this.invitationId = invitationId;
            return this;
        }

        public Builder requestBody(RevokeOrganizationInvitationRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends RevokeOrganizationInvitationRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public RevokeOrganizationInvitationRequest build() {
            return new RevokeOrganizationInvitationRequest(this.organizationId, this.invitationId, this.requestBody);
        }
    }
}

