/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OAuthApplicationWithSecret;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class RotateOAuthApplicationSecretResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OAuthApplicationWithSecret> oAuthApplicationWithSecret;

    @JsonCreator
    public RotateOAuthApplicationSecretResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OAuthApplicationWithSecret> oAuthApplicationWithSecret) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(oAuthApplicationWithSecret, "oAuthApplicationWithSecret");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.oAuthApplicationWithSecret = oAuthApplicationWithSecret;
    }

    public RotateOAuthApplicationSecretResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OAuthApplicationWithSecret> oAuthApplicationWithSecret() {
        return this.oAuthApplicationWithSecret;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public RotateOAuthApplicationSecretResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public RotateOAuthApplicationSecretResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public RotateOAuthApplicationSecretResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public RotateOAuthApplicationSecretResponse withOAuthApplicationWithSecret(OAuthApplicationWithSecret oAuthApplicationWithSecret) {
        Utils.checkNotNull(oAuthApplicationWithSecret, "oAuthApplicationWithSecret");
        this.oAuthApplicationWithSecret = Optional.ofNullable(oAuthApplicationWithSecret);
        return this;
    }

    public RotateOAuthApplicationSecretResponse withOAuthApplicationWithSecret(Optional<? extends OAuthApplicationWithSecret> oAuthApplicationWithSecret) {
        Utils.checkNotNull(oAuthApplicationWithSecret, "oAuthApplicationWithSecret");
        this.oAuthApplicationWithSecret = oAuthApplicationWithSecret;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RotateOAuthApplicationSecretResponse other = (RotateOAuthApplicationSecretResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.oAuthApplicationWithSecret, other.oAuthApplicationWithSecret);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.oAuthApplicationWithSecret);
    }

    public String toString() {
        return Utils.toString(RotateOAuthApplicationSecretResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "oAuthApplicationWithSecret", this.oAuthApplicationWithSecret);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OAuthApplicationWithSecret> oAuthApplicationWithSecret = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder oAuthApplicationWithSecret(OAuthApplicationWithSecret oAuthApplicationWithSecret) {
            Utils.checkNotNull(oAuthApplicationWithSecret, "oAuthApplicationWithSecret");
            this.oAuthApplicationWithSecret = Optional.ofNullable(oAuthApplicationWithSecret);
            return this;
        }

        public Builder oAuthApplicationWithSecret(Optional<? extends OAuthApplicationWithSecret> oAuthApplicationWithSecret) {
            Utils.checkNotNull(oAuthApplicationWithSecret, "oAuthApplicationWithSecret");
            this.oAuthApplicationWithSecret = oAuthApplicationWithSecret;
            return this;
        }

        public RotateOAuthApplicationSecretResponse build() {
            return new RotateOAuthApplicationSecretResponse(this.contentType, this.statusCode, this.rawResponse, this.oAuthApplicationWithSecret);
        }
    }
}

