/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateEmailAddressRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class UpdateEmailAddressRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=email_address_id")
    private String emailAddressId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends UpdateEmailAddressRequestBody> requestBody;

    @JsonCreator
    public UpdateEmailAddressRequest(String emailAddressId, Optional<? extends UpdateEmailAddressRequestBody> requestBody) {
        Utils.checkNotNull(emailAddressId, "emailAddressId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.emailAddressId = emailAddressId;
        this.requestBody = requestBody;
    }

    public UpdateEmailAddressRequest(String emailAddressId) {
        this(emailAddressId, Optional.empty());
    }

    @JsonIgnore
    public String emailAddressId() {
        return this.emailAddressId;
    }

    @JsonIgnore
    public Optional<UpdateEmailAddressRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateEmailAddressRequest withEmailAddressId(String emailAddressId) {
        Utils.checkNotNull(emailAddressId, "emailAddressId");
        this.emailAddressId = emailAddressId;
        return this;
    }

    public UpdateEmailAddressRequest withRequestBody(UpdateEmailAddressRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UpdateEmailAddressRequest withRequestBody(Optional<? extends UpdateEmailAddressRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateEmailAddressRequest other = (UpdateEmailAddressRequest)o;
        return Objects.deepEquals(this.emailAddressId, other.emailAddressId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddressId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateEmailAddressRequest.class, "emailAddressId", this.emailAddressId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String emailAddressId;
        private Optional<? extends UpdateEmailAddressRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder emailAddressId(String emailAddressId) {
            Utils.checkNotNull(emailAddressId, "emailAddressId");
            this.emailAddressId = emailAddressId;
            return this;
        }

        public Builder requestBody(UpdateEmailAddressRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UpdateEmailAddressRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateEmailAddressRequest build() {
            return new UpdateEmailAddressRequest(this.emailAddressId, this.requestBody);
        }
    }
}

