/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.JWTTemplate;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class UpdateJWTTemplateResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends JWTTemplate> jwtTemplate;

    @JsonCreator
    public UpdateJWTTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends JWTTemplate> jwtTemplate) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(jwtTemplate, "jwtTemplate");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.jwtTemplate = jwtTemplate;
    }

    public UpdateJWTTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<JWTTemplate> jwtTemplate() {
        return this.jwtTemplate;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateJWTTemplateResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateJWTTemplateResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateJWTTemplateResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateJWTTemplateResponse withJWTTemplate(JWTTemplate jwtTemplate) {
        Utils.checkNotNull(jwtTemplate, "jwtTemplate");
        this.jwtTemplate = Optional.ofNullable(jwtTemplate);
        return this;
    }

    public UpdateJWTTemplateResponse withJWTTemplate(Optional<? extends JWTTemplate> jwtTemplate) {
        Utils.checkNotNull(jwtTemplate, "jwtTemplate");
        this.jwtTemplate = jwtTemplate;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateJWTTemplateResponse other = (UpdateJWTTemplateResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.jwtTemplate, other.jwtTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.jwtTemplate);
    }

    public String toString() {
        return Utils.toString(UpdateJWTTemplateResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "jwtTemplate", this.jwtTemplate);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends JWTTemplate> jwtTemplate = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder jwtTemplate(JWTTemplate jwtTemplate) {
            Utils.checkNotNull(jwtTemplate, "jwtTemplate");
            this.jwtTemplate = Optional.ofNullable(jwtTemplate);
            return this;
        }

        public Builder jwtTemplate(Optional<? extends JWTTemplate> jwtTemplate) {
            Utils.checkNotNull(jwtTemplate, "jwtTemplate");
            this.jwtTemplate = jwtTemplate;
            return this;
        }

        public UpdateJWTTemplateResponse build() {
            return new UpdateJWTTemplateResponse(this.contentType, this.statusCode, this.rawResponse, this.jwtTemplate);
        }
    }
}

