/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateOrganizationRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class UpdateOrganizationRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UpdateOrganizationRequestBody requestBody;

    @JsonCreator
    public UpdateOrganizationRequest(String organizationId, UpdateOrganizationRequestBody requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public UpdateOrganizationRequestBody requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateOrganizationRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public UpdateOrganizationRequest withRequestBody(UpdateOrganizationRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOrganizationRequest other = (UpdateOrganizationRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateOrganizationRequest.class, "organizationId", this.organizationId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private UpdateOrganizationRequestBody requestBody;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder requestBody(UpdateOrganizationRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateOrganizationRequest build() {
            return new UpdateOrganizationRequest(this.organizationId, this.requestBody);
        }
    }
}

