/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdatePhoneNumberRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class UpdatePhoneNumberRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=phone_number_id")
    private String phoneNumberId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends UpdatePhoneNumberRequestBody> requestBody;

    @JsonCreator
    public UpdatePhoneNumberRequest(String phoneNumberId, Optional<? extends UpdatePhoneNumberRequestBody> requestBody) {
        Utils.checkNotNull(phoneNumberId, "phoneNumberId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.phoneNumberId = phoneNumberId;
        this.requestBody = requestBody;
    }

    public UpdatePhoneNumberRequest(String phoneNumberId) {
        this(phoneNumberId, Optional.empty());
    }

    @JsonIgnore
    public String phoneNumberId() {
        return this.phoneNumberId;
    }

    @JsonIgnore
    public Optional<UpdatePhoneNumberRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdatePhoneNumberRequest withPhoneNumberId(String phoneNumberId) {
        Utils.checkNotNull(phoneNumberId, "phoneNumberId");
        this.phoneNumberId = phoneNumberId;
        return this;
    }

    public UpdatePhoneNumberRequest withRequestBody(UpdatePhoneNumberRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UpdatePhoneNumberRequest withRequestBody(Optional<? extends UpdatePhoneNumberRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatePhoneNumberRequest other = (UpdatePhoneNumberRequest)o;
        return Objects.deepEquals(this.phoneNumberId, other.phoneNumberId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.phoneNumberId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdatePhoneNumberRequest.class, "phoneNumberId", this.phoneNumberId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String phoneNumberId;
        private Optional<? extends UpdatePhoneNumberRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder phoneNumberId(String phoneNumberId) {
            Utils.checkNotNull(phoneNumberId, "phoneNumberId");
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public Builder requestBody(UpdatePhoneNumberRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UpdatePhoneNumberRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdatePhoneNumberRequest build() {
            return new UpdatePhoneNumberRequest(this.phoneNumberId, this.requestBody);
        }
    }
}

