/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.models.operations.UpdatePhoneNumberRequestBody;
import com.clerk.backend_api.models.operations.UpdatePhoneNumberResponse;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdatePhoneNumberRequestBuilder {
    private String phoneNumberId;
    private Optional<? extends UpdatePhoneNumberRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallUpdatePhoneNumber sdk;

    public UpdatePhoneNumberRequestBuilder(SDKMethodInterfaces.MethodCallUpdatePhoneNumber sdk) {
        this.sdk = sdk;
    }

    public UpdatePhoneNumberRequestBuilder phoneNumberId(String phoneNumberId) {
        Utils.checkNotNull(phoneNumberId, "phoneNumberId");
        this.phoneNumberId = phoneNumberId;
        return this;
    }

    public UpdatePhoneNumberRequestBuilder requestBody(UpdatePhoneNumberRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public UpdatePhoneNumberRequestBuilder requestBody(Optional<? extends UpdatePhoneNumberRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdatePhoneNumberRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdatePhoneNumberRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public UpdatePhoneNumberResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.update(this.phoneNumberId, this.requestBody, options);
    }
}

